/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.development;

import com.google.appengine.repackaged.com.google.common.base.Joiner;
import javax.annotation.concurrent.GuardedBy;

public class InstanceStateHolder {
    private static final Joiner STATE_JOINER = Joiner.on((String)"|");
    private final String moduleOrBackendName;
    private final int instance;
    @GuardedBy(value="this")
    private InstanceState currentState = InstanceState.SHUTDOWN;

    InstanceStateHolder(String moduleOrBackendName, int instance) {
        this.moduleOrBackendName = moduleOrBackendName;
        this.instance = instance;
    }

    void testAndSet(InstanceState newState, InstanceState ... acceptablePreviousStates) throws IllegalStateException {
        InstanceState invalidState = this.testAndSetIf(newState, acceptablePreviousStates);
        if (invalidState != null) {
            InstanceStateHolder.reportInvalidStateChange(this.moduleOrBackendName, this.instance, invalidState, newState, acceptablePreviousStates);
        }
    }

    static void reportInvalidStateChange(String moduleOrBackendName, int instance, InstanceState currentState, InstanceState newState, InstanceState ... acceptablePreviousStates) {
        StringBuilder error = new StringBuilder();
        error.append("Tried to change state to " + (Object)((Object)newState));
        error.append(" on module " + moduleOrBackendName + "." + instance);
        error.append(" but previous state is " + (Object)((Object)currentState));
        error.append(" and not ");
        error.append(STATE_JOINER.join((Object[])acceptablePreviousStates));
        throw new IllegalStateException(error.toString());
    }

    synchronized InstanceState testAndSetIf(InstanceState newState, InstanceState ... acceptablePreviousStates) {
        InstanceState result = this.currentState;
        if (this.test(acceptablePreviousStates)) {
            result = null;
            this.currentState = newState;
        }
        return result;
    }

    synchronized boolean test(InstanceState ... acceptableStates) {
        for (InstanceState acceptable : acceptableStates) {
            if (this.currentState != acceptable) continue;
            return true;
        }
        return false;
    }

    synchronized void requireState(String operation, InstanceState ... acceptableStates) {
        if (!this.test(acceptableStates)) {
            throw new IllegalStateException("Invalid current state operation=" + operation + " currentState=" + (Object)((Object)this.currentState) + " acceptableStates=" + STATE_JOINER.join((Object[])acceptableStates));
        }
    }

    synchronized boolean acceptsConnections() {
        return this.currentState == InstanceState.RUNNING || this.currentState == InstanceState.RUNNING_START_REQUEST || this.currentState == InstanceState.SLEEPING;
    }

    synchronized String getDisplayName() {
        return this.currentState.name().toLowerCase();
    }

    synchronized void set(InstanceState newState) {
        this.currentState = newState;
    }

    static enum InstanceState {
        INITIALIZING,
        SLEEPING,
        RUNNING_START_REQUEST,
        RUNNING,
        STOPPED,
        SHUTDOWN;

    }
}

