/*
 * Decompiled with CFR 0.152.
 */
package mediautil.test;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import mediautil.gen.directio.InStreamFromIterativeWriter;
import mediautil.gen.directio.IterativeWriter;
import mediautil.gen.directio.OutStreamToIterativeReader;
import mediautil.gen.directio.SplitInputStream;
import mediautil.image.jpeg.Entry;
import mediautil.image.jpeg.Exif;
import mediautil.image.jpeg.LLJTran;
import mediautil.image.jpeg.LLJTranException;

public class LLJTranTester {
    public static void javaApi(InputStream ip, OutputStream op, OutputStream op1) throws IOException {
        ImageInputStream iis = ImageIO.createImageInputStream(ip);
        ImageReader reader = ImageIO.getImageReaders(iis).next();
        reader.setInput(iis);
        System.out.println("Reader = " + reader);
        System.out.println("********** BEGIN READ: " + new Date());
        BufferedImage image = reader.read(0);
        System.out.println("********** END READ: " + new Date());
        Graphics graphics = image.getGraphics();
        graphics.setColor(new Color(240, 100, 255, 255));
        graphics.drawString("Highlight " + new Date(), 20, image.getHeight() - 40);
        String format = "JPG";
        ImageIO.write((RenderedImage)image, format, op);
        if (op1 != null) {
            ImageIO.write((RenderedImage)image, format, op1);
        }
        iis.close();
    }

    public static LLJTran readShared(String fileName, boolean keep_appxs) throws LLJTranException, IOException {
        FileInputStream fip = new FileInputStream(fileName);
        SplitInputStream sip = new SplitInputStream(fip);
        InputStream subIp = sip.createSubStream();
        LLJTran llj = new LLJTran(subIp);
        llj.initRead(3, keep_appxs, true);
        sip.attachSubReader(llj, subIp);
        BufferedOutputStream fop = new BufferedOutputStream(new FileOutputStream("d.jpg"));
        LLJTranTester.javaApi(sip, fop, null);
        System.out.println("Max Blocks = " + sip.getMaxBufSize());
        System.out.println(" minRead = " + llj.getRequestSize(0) + " maxRead = " + llj.getRequestSize(1));
        sip.wrapup();
        fip.close();
        fop.close();
        System.out.println("frm_x = " + llj.getWidth() + " frm_y = " + llj.getHeight() + " maxHi = " + llj.getMaxHSamplingFactor() + " maxVi = " + llj.getMaxVSamplingFactor() + " widthMCU = " + llj.getWidthInMCU() + " heightMCU = " + llj.getHeightInMCU());
        System.out.println("Info = " + llj.getImageInfo());
        System.out.println("Successfully Read Image");
        return llj;
    }

    public static void readImage(LLJTran llj, boolean keep_appxs, int stage1, int stage2, int stage3) throws LLJTranException {
        if (stage1 != 0) {
            llj.read(stage1, keep_appxs);
        }
        if (stage2 != 0) {
            llj.read(stage2, keep_appxs);
        }
        System.out.println("frm_x = " + llj.getWidth() + " frm_y = " + llj.getHeight() + " maxHi = " + llj.getMaxHSamplingFactor() + " maxVi = " + llj.getMaxVSamplingFactor() + " widthMCU = " + llj.getWidthInMCU() + " heightMCU = " + llj.getHeightInMCU());
        if (stage3 != 0) {
            llj.read(stage3, keep_appxs);
        }
        System.out.println("Info = " + llj.getImageInfo());
        System.out.println("Successfully Read Image");
    }

    public static void main1(String[] args) throws Exception {
        int l;
        LLJTran llj = new LLJTran(new File(args[0]));
        LLJTranTester.readImage(llj, true, 3, 0, 0);
        Rectangle cropArea = new Rectangle();
        byte[] newThumbnail = new byte[100000];
        if (llj.getImageInfo().getThumbnailLength() > 0) {
            FileOutputStream top = new FileOutputStream("del.jpg");
            InputStream tip = llj.getThumbnailAsStream();
            while ((l = tip.read(newThumbnail)) > 0) {
                top.write(newThumbnail, 0, l);
            }
            top.close();
        } else {
            System.out.println("Image has no Thumbnail");
        }
        if (llj.getImageInfoAppxIndex() < 0) {
            System.out.println("Attempting to add Dummy Exif Header");
            llj.addAppx(LLJTran.dummyExifHeader, 0, LLJTran.dummyExifHeader.length, true);
        }
        FileInputStream fip = new FileInputStream("x1.jpg");
        l = fip.read(newThumbnail);
        fip.close();
        llj.setThumbnail(newThumbnail, 0, l, "jpg");
        String opName = args[1];
        String prefix = null;
        String suffix = null;
        if (args.length > 3) {
            int i = opName.lastIndexOf(46);
            if (i < 0) {
                i = opName.length();
            }
            prefix = opName.substring(0, i) + '_';
            suffix = opName.substring(i);
        }
        String currentOpName = opName;
        for (int i = 2; i < args.length; ++i) {
            int options = 797;
            int transformOp = Integer.parseInt(args[i]);
            System.out.println("Transform begun at " + new Date());
            if (transformOp == 8) {
                cropArea.x = Integer.parseInt(args[++i]);
                cropArea.y = Integer.parseInt(args[++i]);
                cropArea.width = Integer.parseInt(args[++i]);
                cropArea.height = Integer.parseInt(args[++i]);
                llj.transform(transformOp, options, cropArea);
            } else {
                llj.transform(transformOp, options);
            }
            System.out.println("Transform ends at " + new Date());
            FileOutputStream op = new FileOutputStream(currentOpName);
            llj.save(op, 768);
            op.close();
            currentOpName = prefix + (i - 1) + suffix;
        }
    }

    public static void main2(String[] args) throws Exception {
        System.out.println("********** BEGIN READ: " + new Date());
        LLJTran llj = LLJTranTester.readShared(args[0], true);
        System.out.println("********** END READ: " + new Date());
        Rectangle cropArea = new Rectangle();
        byte[] newThumbnail = new byte[15000];
        if (llj.getImageInfo().getThumbnailLength() > 0) {
            FileOutputStream top = new FileOutputStream("del.jpg");
            llj.writeThumbnail(top);
        } else {
            System.out.println("Image has no Thumbnail");
        }
        String opName = args[1];
        String prefix = null;
        String suffix = null;
        if (args.length > 2) {
            int i = opName.lastIndexOf(46);
            if (i < 0) {
                i = opName.length();
            }
            prefix = opName.substring(0, i) + '_';
            suffix = opName.substring(i);
        }
        String currentOpName = opName;
        for (int i = 2; i < args.length; ++i) {
            int options = 795;
            int transformOp = Integer.parseInt(args[i]);
            FileOutputStream op = new FileOutputStream(currentOpName);
            if (transformOp == 8) {
                cropArea.x = Integer.parseInt(args[++i]);
                cropArea.y = Integer.parseInt(args[++i]);
                cropArea.width = Integer.parseInt(args[++i]);
                cropArea.height = Integer.parseInt(args[++i]);
                llj.transform(op, transformOp, options, cropArea);
            } else {
                llj.transform(op, transformOp, options);
            }
            op.close();
            currentOpName = prefix + (i - 1) + suffix;
        }
        FileOutputStream op = new FileOutputStream(currentOpName);
        llj.save(op, 768);
        op.close();
    }

    public static void main(String[] args) throws Exception {
        int l;
        LLJTran llj = new LLJTran(new File(args[0]));
        System.out.println("********** BEGIN READ: " + new Date());
        LLJTranTester.readImage(llj, true, 3, 0, 0);
        System.out.println("********** END READ: " + new Date());
        Rectangle cropArea = new Rectangle();
        byte[] newThumbnail = new byte[100000];
        if (llj.getImageInfo().getThumbnailLength() > 0) {
            FileOutputStream top = new FileOutputStream("del.jpg");
            InputStream tip = llj.getThumbnailAsStream();
            while ((l = tip.read(newThumbnail)) > 0) {
                top.write(newThumbnail, 0, l);
            }
            top.close();
        } else {
            System.out.println("Image has no Thumbnail");
        }
        if (llj.getImageInfoAppxIndex() < 0) {
            System.out.println("Attempting to add Dummy Exif Header");
            llj.addAppx(LLJTran.dummyExifHeader, 0, LLJTran.dummyExifHeader.length, true);
        }
        FileInputStream fip = new FileInputStream("x1.jpg");
        l = fip.read(newThumbnail);
        fip.close();
        llj.setThumbnail(newThumbnail, 0, l, "jpg");
        String opName = args[1];
        String prefix = null;
        String suffix = null;
        if (args.length > 3) {
            int i = opName.lastIndexOf(46);
            if (i < 0) {
                i = opName.length();
            }
            prefix = opName.substring(0, i) + '_';
            suffix = opName.substring(i);
        }
        String currentOpName = opName;
        for (int i = 2; i < args.length; ++i) {
            int options = 797;
            int transformOp = Integer.parseInt(args[i]);
            System.out.println("Transform begun at " + new Date());
            if (transformOp == 8) {
                cropArea.x = Integer.parseInt(args[++i]);
                cropArea.y = Integer.parseInt(args[++i]);
                cropArea.width = Integer.parseInt(args[++i]);
                cropArea.height = Integer.parseInt(args[++i]);
                llj.transform(transformOp, options, cropArea);
            } else {
                llj.transform(transformOp, options);
            }
            System.out.println("Transform ends at " + new Date());
            InStreamFromIterativeWriter iwip = new InStreamFromIterativeWriter();
            FileOutputStream op = new FileOutputStream("d.jpg");
            IterativeWriter iWriter = llj.initWrite(iwip.getWriterOutputStream(), 0, 768, null, 0, true);
            iwip.setIterativeWriter(iWriter);
            LLJTran llj1 = new LLJTran(iwip);
            System.out.println("********** BEGIN READ: " + new Date());
            LLJTranTester.readImage(llj1, true, 3, 0, 0);
            System.out.println("********** END READ: " + new Date() + " minWrite = " + llj.getRequestSize(2) + " maxWrite = " + llj.getRequestSize(3));
            llj1.transform(5, 777);
            System.out.println("Max Buf = " + iwip.getMaxBufSize());
            llj1.save(op, 768);
            System.out.println("********** END SAVE: " + new Date());
            llj1.freeMemory();
            llj.wrapupIterativeWrite(iWriter);
            op.close();
            op = new FileOutputStream(currentOpName);
            llj.save(op, 768);
            op.close();
            currentOpName = prefix + (i - 1) + suffix;
        }
    }

    public static void main4(String[] args) throws Exception {
        BufferedInputStream imageIp = new BufferedInputStream(new FileInputStream(args[0]));
        BufferedOutputStream imageOp = new BufferedOutputStream(new FileOutputStream("java.jpg"));
        OutStreamToIterativeReader opToLlj = new OutStreamToIterativeReader();
        LLJTran llj = new LLJTran(opToLlj.getReaderInputStream());
        opToLlj.setIterativeReader(llj);
        llj.initRead(3, true, true);
        LLJTranTester.javaApi(imageIp, opToLlj, imageOp);
        imageIp.close();
        opToLlj.close();
        imageOp.close();
        Rectangle cropArea = new Rectangle();
        byte[] newThumbnail = new byte[15000];
        if (llj.getImageInfo().getThumbnailLength() > 0) {
            FileOutputStream top = new FileOutputStream("del.jpg");
            llj.writeThumbnail(top);
        } else {
            System.out.println("Image has no Thumbnail");
        }
        String opName = args[1];
        String prefix = null;
        String suffix = null;
        if (args.length > 2) {
            int i = opName.lastIndexOf(46);
            if (i < 0) {
                i = opName.length();
            }
            prefix = opName.substring(0, i) + '_';
            suffix = opName.substring(i);
        }
        String currentOpName = opName;
        for (int i = 2; i < args.length; ++i) {
            int options = 795;
            int transformOp = Integer.parseInt(args[i]);
            FileOutputStream op = new FileOutputStream(currentOpName);
            if (transformOp == 8) {
                cropArea.x = Integer.parseInt(args[++i]);
                cropArea.y = Integer.parseInt(args[++i]);
                cropArea.width = Integer.parseInt(args[++i]);
                cropArea.height = Integer.parseInt(args[++i]);
                llj.transform(op, transformOp, options, cropArea);
            } else {
                llj.transform(op, transformOp, options);
            }
            op.close();
            currentOpName = prefix + (i - 1) + suffix;
        }
        FileOutputStream op = new FileOutputStream(currentOpName);
        llj.save(op, 768);
        op.close();
    }

    public static void main5(String[] args) throws Exception {
        LLJTran llj = new LLJTran(new File(args[0]));
        LLJTranTester.readImage(llj, true, 1, 0, 0);
        String newTime = "";
        Exif exif = (Exif)llj.getImageInfo();
        Entry entry = exif.getTagValue(306, true);
        if (entry != null) {
            entry.setValue(0, "1998:08:18 11:15:00");
        }
        if ((entry = exif.getTagValue(36867, true)) != null) {
            entry.setValue(0, "1998:08:18 11:15:00");
        }
        if ((entry = exif.getTagValue(36868, true)) != null) {
            entry.setValue(0, "1998:08:18 11:15:00");
        }
        entry = exif.getTagValue(274, true);
        System.out.println("Orient Entry = " + entry);
        if (entry != null) {
            entry.setValue(0, new Integer(6));
        }
        llj.refreshAppx();
        FileOutputStream nhOp = new FileOutputStream("del.jpg");
        llj.xferInfo(null, nhOp, 0, 0);
        nhOp.close();
        llj.read(3, true);
        FileOutputStream op = new FileOutputStream(args[1]);
        int transformOp = Integer.parseInt(args[2]);
        llj.transform(op, transformOp);
        op.close();
    }
}

