/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.simpl;

import com.google.appengine.repackaged.org.apache.commons.logging.Log;
import com.google.appengine.repackaged.org.apache.commons.logging.LogFactory;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.SchedulerException;
import org.quartz.simpl.SimpleJobFactory;
import org.quartz.spi.TriggerFiredBundle;

public class PropertySettingJobFactory
extends SimpleJobFactory {
    private Log log = LogFactory.getLog((Class)(class$org$quartz$simpl$SimpleJobFactory == null ? (class$org$quartz$simpl$SimpleJobFactory = PropertySettingJobFactory.class$("org.quartz.simpl.SimpleJobFactory")) : class$org$quartz$simpl$SimpleJobFactory));
    private boolean warnIfNotFound = true;
    private boolean throwIfNotFound = false;
    static /* synthetic */ Class class$org$quartz$simpl$SimpleJobFactory;
    static /* synthetic */ Class class$java$lang$String;

    public Job newJob(TriggerFiredBundle bundle) throws SchedulerException {
        Job job = super.newJob(bundle);
        JobDataMap jobDataMap = new JobDataMap();
        jobDataMap.putAll((Map)bundle.getJobDetail().getJobDataMap());
        jobDataMap.putAll((Map)bundle.getTrigger().getJobDataMap());
        this.setBeanProps(job, jobDataMap);
        return job;
    }

    protected void setBeanProps(Object obj, JobDataMap data) throws SchedulerException {
        BeanInfo bi;
        block29: {
            bi = null;
            try {
                bi = Introspector.getBeanInfo(obj.getClass());
            }
            catch (IntrospectionException e1) {
                if (this.isThrowIfPropertyNotFound()) {
                    throw new SchedulerException("Unable to introspect Job class.", e1);
                }
                if (!this.isWarnIfPropertyNotFound()) break block29;
                this.log.warn((Object)"Unable to introspect Job class.", (Throwable)e1);
            }
        }
        PropertyDescriptor[] propDescs = bi.getPropertyDescriptors();
        Iterator keys = data.keySet().iterator();
        while (keys.hasNext()) {
            String name = (String)keys.next();
            String c = name.substring(0, 1).toUpperCase(Locale.US);
            String methName = "set" + c + name.substring(1);
            Method setMeth = this.getSetMethod(methName, propDescs);
            Class<?> paramType = null;
            Object o = null;
            try {
                if (setMeth == null) {
                    if (this.isThrowIfPropertyNotFound()) {
                        throw new SchedulerException("No setter on Job class " + obj.getClass() + " for property '" + name + "'");
                    }
                    if (!this.isWarnIfPropertyNotFound()) continue;
                    this.log.warn((Object)("No setter on Job class " + obj.getClass() + " for property '" + name + "'"));
                    continue;
                }
                paramType = setMeth.getParameterTypes()[0];
                o = data.get(name);
                if (paramType.equals(Integer.TYPE)) {
                    if (o instanceof Integer) {
                        setMeth.invoke(obj, o);
                        continue;
                    }
                    if (!(o instanceof String)) continue;
                    setMeth.invoke(obj, data.getIntegerFromString(name));
                    continue;
                }
                if (paramType.equals(Long.TYPE)) {
                    if (o instanceof Long) {
                        setMeth.invoke(obj, o);
                        continue;
                    }
                    if (!(o instanceof String)) continue;
                    setMeth.invoke(obj, data.getLongFromString(name));
                    continue;
                }
                if (paramType.equals(Float.TYPE)) {
                    if (o instanceof Float) {
                        setMeth.invoke(obj, o);
                        continue;
                    }
                    if (!(o instanceof String)) continue;
                    setMeth.invoke(obj, data.getFloatFromString(name));
                    continue;
                }
                if (paramType.equals(Double.TYPE)) {
                    if (o instanceof Double) {
                        setMeth.invoke(obj, o);
                        continue;
                    }
                    if (!(o instanceof String)) continue;
                    setMeth.invoke(obj, data.getDoubleFromString(name));
                    continue;
                }
                if (paramType.equals(Boolean.TYPE)) {
                    if (o instanceof Boolean) {
                        setMeth.invoke(obj, o);
                        continue;
                    }
                    if (!(o instanceof String)) continue;
                    setMeth.invoke(obj, data.getBooleanFromString(name));
                    continue;
                }
                if (paramType.equals(class$java$lang$String == null ? PropertySettingJobFactory.class$("java.lang.String") : class$java$lang$String)) {
                    if (!(o instanceof String)) continue;
                    setMeth.invoke(obj, o);
                    continue;
                }
                if (paramType.isAssignableFrom(o.getClass())) {
                    setMeth.invoke(obj, o);
                    continue;
                }
                throw new NoSuchMethodException();
            }
            catch (NumberFormatException nfe) {
                if (this.isThrowIfPropertyNotFound()) {
                    throw new SchedulerException("The setter on Job class " + obj.getClass() + " for property '" + name + "' expects a " + paramType + " but was given " + o, nfe);
                }
                if (!this.isWarnIfPropertyNotFound()) continue;
                this.log.warn((Object)("The setter on Job class " + obj.getClass() + " for property '" + name + "' expects a " + paramType + " but was given " + o), (Throwable)nfe);
            }
            catch (NoSuchMethodException e) {
                if (this.isThrowIfPropertyNotFound()) {
                    throw new SchedulerException("The setter on Job class " + obj.getClass() + " for property '" + name + "' expects a " + paramType + " but was given " + o.getClass());
                }
                if (!this.isWarnIfPropertyNotFound()) continue;
                this.log.warn((Object)("The setter on Job class " + obj.getClass() + " for property '" + name + "' expects a " + paramType + " but was given a " + o.getClass()));
            }
            catch (IllegalArgumentException e) {
                if (this.isThrowIfPropertyNotFound()) {
                    throw new SchedulerException("The setter on Job class " + obj.getClass() + " for property '" + name + "' expects a " + paramType + " but was given " + o.getClass(), e);
                }
                if (!this.isWarnIfPropertyNotFound()) continue;
                this.log.warn((Object)("The setter on Job class " + obj.getClass() + " for property '" + name + "' expects a " + paramType + " but was given a " + o.getClass()), (Throwable)e);
            }
            catch (IllegalAccessException e) {
                if (this.isThrowIfPropertyNotFound()) {
                    throw new SchedulerException("The setter on Job class " + obj.getClass() + " for property '" + name + "' could not be accessed.", e);
                }
                if (!this.isWarnIfPropertyNotFound()) continue;
                this.log.warn((Object)("The setter on Job class " + obj.getClass() + " for property '" + name + "' expects a " + paramType + "' could not be accessed."), (Throwable)e);
            }
            catch (InvocationTargetException e) {
                if (this.isThrowIfPropertyNotFound()) {
                    throw new SchedulerException("The setter on Job class " + obj.getClass() + " for property '" + name + "' could not be accessed.", e);
                }
                if (!this.isWarnIfPropertyNotFound()) continue;
                this.log.warn((Object)("The setter on Job class " + obj.getClass() + " for property '" + name + "' expects a " + paramType + "' could not be accessed."), (Throwable)e);
            }
        }
    }

    private Method getSetMethod(String name, PropertyDescriptor[] props) {
        for (int i = 0; i < props.length; ++i) {
            Method wMeth = props[i].getWriteMethod();
            if (wMeth == null || wMeth.getParameterTypes().length != 1 || !wMeth.getName().equals(name)) continue;
            return wMeth;
        }
        return null;
    }

    public boolean isThrowIfPropertyNotFound() {
        return this.throwIfNotFound;
    }

    public void setThrowIfPropertyNotFound(boolean throwIfNotFound) {
        this.throwIfNotFound = throwIfNotFound;
    }

    public boolean isWarnIfPropertyNotFound() {
        return this.warnIfNotFound;
    }

    public void setWarnIfPropertyNotFound(boolean warnIfNotFound) {
        this.warnIfNotFound = warnIfNotFound;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

