/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.development.agent.impl;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.objectweb.asm.ClassAdapter;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;

public class ClassLoaderVisitor
extends ClassAdapter {
    private static final String RECORD_CLASSLOADER = "recordClassLoader";
    private static final String RECORD_CLASSLOADER_DESCRIPTOR = "(Ljava/lang/ClassLoader;)V";
    private static final String CHECK_PARENT_CLASSLOADER = "checkParentClassLoader";
    private static final String CHECK_PARENT_CLASSLOADER_DESCRIPTOR = "(Ljava/lang/ClassLoader;)Ljava/lang/ClassLoader;";
    private static final String URL_CLASSLOADER_CLASS = "java/net/URLClassLoader";
    private static final String SECURE_CLASSLOADER_CLASS = "java/security/SecureClassLoader";
    private static final String CLASSLOADER_CLASS = "java/lang/ClassLoader";
    private static final String CONSTRUCTOR_METHOD = "<init>";
    private static final String NEW_INSTANCE_METHOD = "newInstance";
    private Set<String> classLoaderTypes = new HashSet<String>(Arrays.asList("java/net/URLClassLoader", "java/security/SecureClassLoader", "java/lang/ClassLoader"));
    private static final Type CLASSLOADER_TYPE = Type.getType(ClassLoader.class);

    public ClassLoaderVisitor(ClassVisitor classVisitor) {
        super(classVisitor);
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
        return mv == null ? null : new MethodTranslator(mv, access, name, desc);
    }

    private class MethodTranslator
    extends GeneratorAdapter {
        MethodTranslator(MethodVisitor methodVisitor, int access, String name, String desc) {
            super(methodVisitor, access, name, desc);
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc) {
            boolean acceptsParentClassLoader;
            InitType initType = this.initsNewClassLoader(owner, name);
            if (initType == InitType.None) {
                super.visitMethodInsn(opcode, owner, name, desc);
                return;
            }
            Type[] argTypes = Type.getArgumentTypes(desc);
            boolean bl = acceptsParentClassLoader = argTypes.length > 0 && argTypes[argTypes.length - 1].equals(CLASSLOADER_TYPE);
            if (!acceptsParentClassLoader) {
                super.visitInsn(1);
            }
            super.visitMethodInsn(184, "com/google/appengine/tools/development/agent/runtime/Runtime", ClassLoaderVisitor.CHECK_PARENT_CLASSLOADER, ClassLoaderVisitor.CHECK_PARENT_CLASSLOADER_DESCRIPTOR);
            if (!acceptsParentClassLoader) {
                Type[] newArgTypes = new Type[argTypes.length + 1];
                System.arraycopy(argTypes, 0, newArgTypes, 0, argTypes.length);
                newArgTypes[argTypes.length] = CLASSLOADER_TYPE;
                argTypes = newArgTypes;
            }
            if (initType == InitType.Init) {
                int i;
                int[] locals = new int[argTypes.length];
                for (i = argTypes.length - 1; i >= 0; --i) {
                    locals[i] = super.newLocal(argTypes[i]);
                    super.storeLocal(locals[i]);
                }
                super.dup();
                for (i = 0; i < locals.length; ++i) {
                    super.loadLocal(locals[i]);
                }
            }
            super.visitMethodInsn(opcode, owner, name, Type.getMethodDescriptor(Type.getReturnType(desc), argTypes));
            if (initType == InitType.NewInstance) {
                super.dup();
            }
            super.visitMethodInsn(184, "com/google/appengine/tools/development/agent/runtime/Runtime", ClassLoaderVisitor.RECORD_CLASSLOADER, ClassLoaderVisitor.RECORD_CLASSLOADER_DESCRIPTOR);
        }

        private InitType initsNewClassLoader(String owner, String name) {
            if (ClassLoaderVisitor.this.classLoaderTypes.contains(owner) && name.equals(ClassLoaderVisitor.CONSTRUCTOR_METHOD)) {
                return InitType.Init;
            }
            if (owner.equals(ClassLoaderVisitor.URL_CLASSLOADER_CLASS) && name.equals(ClassLoaderVisitor.NEW_INSTANCE_METHOD)) {
                return InitType.NewInstance;
            }
            return InitType.None;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum InitType {
        None,
        Init,
        NewInstance;

    }
}

