/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.util;

import java.util.StringTokenizer;

public abstract class Option {
    private final String shortName;
    private final String longName;
    private final boolean isFlag;
    private Style style;
    private String value;

    public Option(String shortName, String longName, boolean isFlag) {
        this.shortName = shortName;
        this.longName = longName;
        this.isFlag = isFlag;
    }

    public boolean isFlag() {
        return this.isFlag;
    }

    public Style getArgStyle() {
        return this.style;
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return "Option{shortName='" + this.shortName + '\'' + ", longName='" + this.longName + '\'' + ", isFlag=" + this.isFlag + ", style=" + (Object)((Object)this.style) + ", value='" + this.value + '\'' + '}';
    }

    public abstract void apply();

    boolean parse(String[] args, int currentArg) {
        String argVal = args[currentArg];
        if (this.shortName != null && argVal.equals("-" + this.shortName)) {
            if (this.isFlag()) {
                return true;
            }
            if (currentArg + 1 == args.length) {
                throw new IllegalArgumentException(this.shortName + " requires an argument.\n");
            }
            this.value = args[currentArg + 1];
            this.style = Style.Short;
            return true;
        }
        if (this.longName != null) {
            if (this.isFlag()) {
                return argVal.equals("--" + this.longName);
            }
            if (!argVal.startsWith("--" + this.longName + "=")) {
                return false;
            }
            StringTokenizer st = new StringTokenizer(argVal, "=");
            st.nextToken();
            if (!st.hasMoreTokens()) {
                throw new IllegalArgumentException(this.longName + " requires an argument, for example, \"" + this.longName + "=FOO\"\n");
            }
            this.value = st.nextToken();
            this.style = Style.Long;
            return true;
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Style {
        Short,
        Long;

    }
}

