/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.appstats;

import com.google.appengine.api.memcache.Expiration;
import com.google.appengine.api.memcache.MemcacheService;
import com.google.appengine.repackaged.com.google.protobuf.Descriptors;
import com.google.appengine.repackaged.com.google.protobuf.InvalidProtocolBufferException;
import com.google.appengine.tools.appstats.Recorder;
import com.google.appengine.tools.appstats.StatsProtos;
import com.google.apphosting.api.ApiProxy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MemcacheWriter
implements Recorder.RecordWriter {
    private static final int FIRST_FIELD_NUMBER_FOR_DETAILS = 100;
    private static final String KEY_PREFIX = "__appstats__";
    private static final String KEY_TEMPLATE = ":%06d";
    private static final String PART_SUFFIX = ":part";
    private static final String FULL_SUFFIX = ":full";
    private static final int KEY_DISTANCE = 100;
    private static final int KEY_MODULUS = 1000;
    private static final int EXPIRATION_SECONDS = 129600;
    public static final String STATS_NAMESPACE = "__appstats__";
    protected final Logger log = Logger.getLogger(this.getClass().getName());
    private final Recorder.Clock clock;
    String keyInCache;
    private final MemcacheService statsMemcache;

    private static String makeKeyPrefix(long timestamp) {
        return String.format("__appstats__:%06d", timestamp / 100L % 1000L * 100L);
    }

    public MemcacheWriter(Recorder.Clock clock, MemcacheService service) {
        this.clock = clock;
        this.keyInCache = this.getClass().getName() + ".CACHED_STATS";
        this.statsMemcache = service;
        if (service == null) {
            throw new NullPointerException("Memcache service not found");
        }
    }

    @Override
    public final Long begin(ApiProxy.Delegate<?> wrappedDelegate, ApiProxy.Environment environment, HttpServletRequest request) {
        long beganAt = this.clock.currentTimeMillis();
        StatsProtos.RequestStatProto.Builder builder = StatsProtos.RequestStatProto.newBuilder();
        builder.setStartTimestampMilliseconds(beganAt);
        builder.setHttpMethod(request.getMethod());
        builder.setHttpPath(request.getRequestURI());
        String queryUnescaped = request.getQueryString();
        if (queryUnescaped != null && queryUnescaped.length() > 0) {
            builder.setHttpQuery("?" + queryUnescaped);
        }
        builder.setIsAdmin(environment.isAdmin());
        if (environment.getEmail() != null) {
            builder.setUserEmail(environment.getEmail());
        }
        builder.setOverheadWalltimeMilliseconds(this.clock.currentTimeMillis() - beganAt);
        environment.getAttributes().put(this.keyInCache, builder);
        return beganAt;
    }

    @Override
    public final boolean commit(ApiProxy.Delegate<?> wrappedDelegate, ApiProxy.Environment environment, Integer responseCode) {
        StatsProtos.RequestStatProto.Builder builder = (StatsProtos.RequestStatProto.Builder)((Object)environment.getAttributes().get(this.keyInCache));
        if (builder == null) {
            return false;
        }
        builder.setDurationMilliseconds(this.clock.currentTimeMillis() - builder.getStartTimestampMilliseconds());
        if (responseCode != null) {
            builder.setHttpStatus(responseCode);
        } else {
            builder.clearHttpStatus();
        }
        HashMap<String, StatsProtos.AggregateRpcStatsProto.Builder> aggregates = new HashMap<String, StatsProtos.AggregateRpcStatsProto.Builder>();
        for (StatsProtos.IndividualRpcStatsProto stat : builder.getIndividualStatsList()) {
            String key = stat.getServiceCallName();
            if (!aggregates.containsKey(key)) {
                aggregates.put(key, StatsProtos.AggregateRpcStatsProto.newBuilder().setServiceCallName(stat.getServiceCallName()).setTotalAmountOfCalls(0L));
            }
            StatsProtos.AggregateRpcStatsProto.Builder aggregate = (StatsProtos.AggregateRpcStatsProto.Builder)((Object)aggregates.get(key));
            aggregate.setTotalAmountOfCalls(aggregate.getTotalAmountOfCalls() + 1L);
        }
        for (StatsProtos.AggregateRpcStatsProto.Builder aggregate : aggregates.values()) {
            builder.addRpcStats(aggregate.build());
        }
        environment.getAttributes().remove(this.keyInCache);
        this.persist(builder.build());
        return true;
    }

    @Override
    public final void write(ApiProxy.Delegate<?> wrappedDelegate, ApiProxy.Environment environment, StatsProtos.IndividualRpcStatsProto.Builder record, long overheadWalltimeMillis, boolean correctStartOffset) {
        if (record == null) {
            throw new NullPointerException("Record must not be null");
        }
        if (environment == null) {
            throw new NullPointerException("Environment must not be null");
        }
        StatsProtos.RequestStatProto.Builder builder = (StatsProtos.RequestStatProto.Builder)((Object)environment.getAttributes().get(this.keyInCache));
        if (builder != null) {
            if (correctStartOffset) {
                record.setStartOffsetMilliseconds(Math.max(0L, record.getStartOffsetMilliseconds() - builder.getStartTimestampMilliseconds()));
            }
            builder.addIndividualStats(record);
            builder.setOverheadWalltimeMilliseconds(builder.getOverheadWalltimeMilliseconds() + overheadWalltimeMillis);
        }
    }

    @Override
    public List<StatsProtos.RequestStatProto> getSummaries() {
        ArrayList<String> keys = new ArrayList<String>(1000);
        for (int i = 0; i < 1000; ++i) {
            keys.add(MemcacheWriter.makeKeyPrefix(i * 100) + PART_SUFFIX);
        }
        ArrayList<StatsProtos.RequestStatProto> result = new ArrayList<StatsProtos.RequestStatProto>();
        for (Map.Entry entry : this.statsMemcache.getAll(keys).entrySet()) {
            try {
                result.add(((StatsProtos.RequestStatProto.Builder)StatsProtos.RequestStatProto.newBuilder().mergeFrom((byte[])entry.getValue())).build());
            }
            catch (InvalidProtocolBufferException e) {
                this.log.warning("Memcache store for request stats is partially corrupted for key " + entry.getKey());
                this.statsMemcache.delete(entry.getKey());
            }
        }
        return result;
    }

    @Override
    public StatsProtos.RequestStatProto getFull(long timestamp) {
        String key = MemcacheWriter.makeKeyPrefix(timestamp) + FULL_SUFFIX;
        try {
            byte[] rawData = (byte[])this.statsMemcache.get((Object)key);
            return rawData == null ? null : ((StatsProtos.RequestStatProto.Builder)StatsProtos.RequestStatProto.newBuilder().mergeFrom(rawData)).build();
        }
        catch (InvalidProtocolBufferException e) {
            this.log.warning("Memcache store for request stats is partially corrupted for key " + key);
            this.statsMemcache.delete((Object)key);
            return null;
        }
    }

    private void persist(StatsProtos.RequestStatProto stats) {
        StatsProtos.RequestStatProto.Builder summary = StatsProtos.RequestStatProto.newBuilder().mergeFrom(stats);
        for (Descriptors.FieldDescriptor field : StatsProtos.RequestStatProto.getDescriptor().getFields()) {
            if (field.getNumber() <= 100) continue;
            summary.clearField(field);
        }
        HashMap<String, byte[]> values = new HashMap<String, byte[]>();
        String prefix = MemcacheWriter.makeKeyPrefix(stats.getStartTimestampMilliseconds());
        values.put(prefix + PART_SUFFIX, summary.build().toByteArray());
        values.put(prefix + FULL_SUFFIX, stats.toByteArray());
        this.statsMemcache.putAll(values, Expiration.byDeltaSeconds((int)129600));
    }
}

