/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore;

import com.google.appengine.api.datastore.InQuerySplitter;
import com.google.appengine.api.datastore.MultiQueryBuilder;
import com.google.appengine.api.datastore.MultiQueryComponent;
import com.google.appengine.api.datastore.NotEqualQuerySplitter;
import com.google.appengine.api.datastore.Query;
import com.google.appengine.api.datastore.QuerySplitComponent;
import com.google.appengine.api.datastore.QuerySplitter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class QuerySplitHelper {
    private static final int MAX_PARALLEL_QUERIES = 30;
    private static final Collection<QuerySplitter> QUERY_SPLITTERS = Collections.synchronizedCollection(Arrays.asList(new NotEqualQuerySplitter(), new InQuerySplitter()));

    private QuerySplitHelper() {
    }

    static MultiQueryBuilder splitQuery(Query query) {
        return QuerySplitHelper.splitQuery(query, QUERY_SPLITTERS);
    }

    static MultiQueryBuilder splitQuery(Query query, Collection<QuerySplitter> splitters) {
        LinkedList<Query.FilterPredicate> remainingFilters = new LinkedList<Query.FilterPredicate>(query.getFilterPredicates());
        ArrayList<QuerySplitComponent> components = new ArrayList<QuerySplitComponent>();
        for (QuerySplitter splitter : splitters) {
            components.addAll(splitter.split(remainingFilters, query.getSortPredicates()));
        }
        if (components.size() > 0) {
            return new MultiQueryBuilder(query, remainingFilters, QuerySplitHelper.convertComponents(components, query.getSortPredicates().size()));
        }
        return null;
    }

    static List<MultiQueryComponent> convertComponents(List<QuerySplitComponent> components, int numberOfSorts) {
        if (components.isEmpty()) {
            throw new IllegalArgumentException();
        }
        ArrayList<MultiQueryComponent> result = new ArrayList<MultiQueryComponent>(components.size());
        Collections.sort(components);
        MultiQueryComponent.Order applyToRemaining = numberOfSorts == 0 ? MultiQueryComponent.Order.SERIAL : null;
        int currentSortIndex = 0;
        int totalParallelQueries = 1;
        for (QuerySplitComponent component : components) {
            if (applyToRemaining == null && component.getSortIndex() != currentSortIndex) {
                if (component.getSortIndex() == currentSortIndex + 1) {
                    ++currentSortIndex;
                } else {
                    applyToRemaining = MultiQueryComponent.Order.PARALLEL;
                }
            }
            result.add(new MultiQueryComponent(applyToRemaining != null ? applyToRemaining : MultiQueryComponent.Order.SERIAL, component.getFilters()));
            if (applyToRemaining != MultiQueryComponent.Order.PARALLEL || (totalParallelQueries *= component.getFilters().size()) <= 30) continue;
            throw new IllegalArgumentException("Splitting the provided query requires that too many subqueries are merged in memory.");
        }
        return result;
    }
}

