/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.development;

import com.google.appengine.api.utils.SystemProperty;
import com.google.appengine.repackaged.com.google.common.base.Join;
import com.google.appengine.repackaged.com.google.common.collect.Maps;
import com.google.appengine.tools.development.ContainerService;
import com.google.appengine.tools.development.LocalEnvironment;
import com.google.appengine.tools.development.LocalServerEnvironment;
import com.google.appengine.tools.info.SdkImplInfo;
import com.google.appengine.tools.info.SdkInfo;
import com.google.apphosting.api.ApiProxy;
import com.google.apphosting.utils.config.AppEngineConfigException;
import com.google.apphosting.utils.config.AppEngineWebXml;
import com.google.apphosting.utils.config.AppEngineWebXmlReader;
import com.google.apphosting.utils.config.AppYaml;
import com.google.apphosting.utils.config.WebXml;
import com.google.apphosting.utils.config.WebXmlReader;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.Permissions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractContainerService
implements ContainerService {
    private static final Logger log = Logger.getLogger(AbstractContainerService.class.getName());
    protected static final String _AH_URL_RELOAD = "/_ah/reloadwebapp";
    private static final String LOGGING_CONFIG_FILE = "java.util.logging.config.file";
    protected String address;
    protected int port;
    protected String webXmlLocation;
    protected File appDir;
    protected String devAppServerVersion;
    protected AppEngineWebXmlReader appEngineWebXmlReader;
    protected AppEngineWebXml appEngineWebXml;
    protected WebXml webXml;
    private final Properties originalSysProps = new Properties();
    private ContainerService.EnvironmentVariableMismatchSeverity envVarMismatchSeverity = ContainerService.EnvironmentVariableMismatchSeverity.ERROR;
    private CountDownLatch serverInitLatch;

    @Override
    public final LocalServerEnvironment configure(String devAppServerVersion, final File appDir, String webXmlLocation, AppEngineWebXmlReader appEngineWebXmlReader, final String address, int port) {
        this.appDir = appDir;
        this.devAppServerVersion = devAppServerVersion;
        this.webXmlLocation = webXmlLocation;
        this.appEngineWebXmlReader = appEngineWebXmlReader;
        this.address = address;
        this.port = port;
        this.serverInitLatch = new CountDownLatch(1);
        return new LocalServerEnvironment(){

            public File getAppDir() {
                return appDir;
            }

            public String getAddress() {
                return address;
            }

            public int getPort() {
                return AbstractContainerService.this.port;
            }

            public void waitForServerToStart() throws InterruptedException {
                AbstractContainerService.this.serverInitLatch.await();
            }
        };
    }

    @Override
    public final void startup() throws Exception {
        File webAppDir = this.initContext();
        this.loadAppEngineWebXml(webAppDir);
        this.startContainer();
        this.startHotDeployScanner();
        this.serverInitLatch.countDown();
    }

    @Override
    public final void shutdown() throws Exception {
        this.stopHotDeployScanner();
        this.stopContainer();
        this.restoreSystemProperties();
    }

    protected abstract File initContext() throws IOException;

    protected abstract void startContainer() throws Exception;

    protected abstract void stopContainer() throws Exception;

    protected abstract void startHotDeployScanner() throws Exception;

    protected abstract void stopHotDeployScanner() throws Exception;

    protected abstract void reloadWebApp() throws Exception;

    @Override
    public String getAddress() {
        return this.address;
    }

    @Override
    public File getAppDirectory() {
        return this.appDir;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public void setEnvironmentVariableMismatchSeverity(ContainerService.EnvironmentVariableMismatchSeverity val) {
        this.envVarMismatchSeverity = val;
    }

    protected Permissions getUserPermissions() {
        return this.appEngineWebXml.getUserPermissions();
    }

    protected void loadAppEngineWebXml(File webAppDir) {
        if (this.appEngineWebXmlReader == null) {
            this.appEngineWebXmlReader = new AppEngineWebXmlReader(webAppDir.getAbsolutePath());
        }
        AppYaml.convert(new File(this.appDir, "WEB-INF"), this.appEngineWebXmlReader.getFilename(), this.webXmlLocation == null ? new File(this.appDir, "WEB-INF/web.xml").getAbsolutePath() : this.webXmlLocation);
        this.appEngineWebXml = this.appEngineWebXmlReader.readAppEngineWebXml();
        if (this.appEngineWebXml.getAppId() == null || this.appEngineWebXml.getAppId().length() == 0) {
            this.appEngineWebXml.setAppId("no_app_id");
        }
        this.webXml = new WebXmlReader(webAppDir.getAbsolutePath()).readWebXml();
        this.setSystemProperties(this.appEngineWebXml);
        this.checkEnvironmentVariables(this.appEngineWebXml);
        this.updateLoggingConfiguration(this.originalSysProps, this.appEngineWebXml.getSystemProperties());
        this.webXml.validate();
        ApiProxy.setEnvironmentForCurrentThread((ApiProxy.Environment)new LocalInitializationEnvironment(this.appEngineWebXml));
    }

    protected void restoreSystemProperties() {
        for (String key : this.appEngineWebXml.getSystemProperties().keySet()) {
            System.clearProperty(key);
        }
        System.getProperties().putAll((Map<?, ?>)this.originalSysProps);
    }

    protected boolean isSessionsEnabled() {
        return this.appEngineWebXml.getSessionsEnabled();
    }

    protected URL[] getClassPathForApp(File root) {
        ArrayList<URL> appUrls = new ArrayList<URL>();
        appUrls.addAll(SdkImplInfo.getAgentRuntimeLibs());
        try {
            File classes = new File(new File(root, "WEB-INF"), "classes");
            if (classes.exists()) {
                appUrls.add(classes.toURL());
            }
        }
        catch (MalformedURLException ex) {
            log.log(Level.WARNING, "Could not add WEB-INF/classes", ex);
        }
        File libDir = new File(new File(root, "WEB-INF"), "lib");
        if (libDir.isDirectory()) {
            for (File file : libDir.listFiles()) {
                try {
                    appUrls.add(file.toURL());
                }
                catch (MalformedURLException ex) {
                    log.log(Level.WARNING, "Could not get URL for file: " + file, ex);
                }
            }
        }
        for (URL url : SdkImplInfo.getUserJspLibs()) {
            appUrls.add(url);
        }
        return appUrls.toArray(new URL[appUrls.size()]);
    }

    protected void setSystemProperties(AppEngineWebXml appEngineWebXml) {
        SystemProperty.environment.set(SystemProperty.Environment.Value.Development);
        String release = SdkInfo.getLocalVersion().getRelease();
        if (release == null) {
            release = "null";
        }
        SystemProperty.version.set(release);
        SystemProperty.applicationId.set(appEngineWebXml.getAppId());
        SystemProperty.applicationVersion.set(appEngineWebXml.getMajorVersionId() + ".1");
        this.originalSysProps.putAll((Map<?, ?>)System.getProperties());
        System.getProperties().putAll(appEngineWebXml.getSystemProperties());
    }

    protected void updateLoggingConfiguration(Properties systemProperties, Map<String, String> userSystemProperties) {
        String userConfigFile = userSystemProperties.get(LOGGING_CONFIG_FILE);
        Properties userProperties = this.loadPropertiesFile(userConfigFile);
        String sdkConfigFile = systemProperties.getProperty(LOGGING_CONFIG_FILE);
        Properties sdkProperties = this.loadPropertiesFile(sdkConfigFile);
        Properties allProperties = new Properties();
        if (sdkProperties != null) {
            allProperties.putAll((Map<?, ?>)sdkProperties);
        }
        if (userProperties != null) {
            allProperties.putAll((Map<?, ?>)userProperties);
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            allProperties.store(out, null);
            LogManager.getLogManager().readConfiguration(new ByteArrayInputStream(out.toByteArray()));
            Handler[] handlers = Logger.getLogger("").getHandlers();
            if (handlers != null) {
                for (Handler handler : handlers) {
                    handler.setLevel(Level.FINEST);
                }
            }
        }
        catch (IOException e) {
            log.log(Level.WARNING, "Unable to configure logging properties.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties loadPropertiesFile(String file) {
        if (file == null) {
            return null;
        }
        File f = new File(file = file.replace('/', File.separatorChar));
        if (!f.isAbsolute()) {
            f = new File(this.appDir + File.separator + f.getPath());
        }
        InputStream inputStream = null;
        try {
            inputStream = new BufferedInputStream(new FileInputStream(f));
            Properties props = new Properties();
            props.load(inputStream);
            Properties properties = props;
            return properties;
        }
        catch (IOException e) {
            log.log(Level.WARNING, "Unable to load properties file, " + f.getAbsolutePath(), e);
            Properties properties = null;
            return properties;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {}
            }
        }
    }

    protected void checkEnvironmentVariables(AppEngineWebXml appEngineWebXml) {
        HashMap<String, String> missingEnvEntries = Maps.newHashMap();
        for (Map.Entry<String, String> entry : appEngineWebXml.getEnvironmentVariables().entrySet()) {
            if (entry.getValue().equals(System.getenv(entry.getKey()))) continue;
            missingEnvEntries.put(entry.getKey(), entry.getValue());
        }
        if (!missingEnvEntries.isEmpty()) {
            String msg = "One or more environment variables have been configured in appengine-web.xml that have missing or different values in your local environment. We recommend you use system properties instead, but if you are interacting with legacy code that requires specific environment variables to have specific values, please set these environment variables in your environment before running.\n" + Join.join("\n", missingEnvEntries, new Object[0]);
            if (this.envVarMismatchSeverity == ContainerService.EnvironmentVariableMismatchSeverity.WARNING) {
                log.warning(msg);
            } else {
                throw new IncorrectEnvironmentVariableException(msg, missingEnvEntries);
            }
        }
    }

    protected static class LocalInitializationEnvironment
    extends LocalEnvironment {
        public LocalInitializationEnvironment(AppEngineWebXml appEngineWebXml) {
            super(appEngineWebXml);
        }

        public String getEmail() {
            return null;
        }

        public boolean isLoggedIn() {
            return false;
        }

        public boolean isAdmin() {
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class IncorrectEnvironmentVariableException
    extends AppEngineConfigException {
        private final Map<String, String> missingEnvEntries;

        private IncorrectEnvironmentVariableException(String msg, Map<String, String> missingEnvEntries) {
            super(msg);
            this.missingEnvEntries = missingEnvEntries;
        }

        public Map<String, String> getMissingEnvEntries() {
            return this.missingEnvEntries;
        }
    }
}

