/*
 * Copyright (C) 2010 Google Inc
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.datanucleus.store.appengine;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

/**
 * @author Max Ross <max.ross@gmail.com>
 */
public class ThreadPoolTest {

  public static final class ThreadPoolWrapper {
    public ThreadPoolWrapper(ExecutorService exec) {
      for (int i = 0; i < 1000; i++) {
        exec.submit(new Callable<Void>() {
          public Void call() throws Exception {
            return null;
          }
        });
      }
    }

    @Override
    protected void finalize() throws Throwable {
      super.finalize();
      System.out.println("-------------------------------->finalize!");
    }
  }

  public static void main(String[] args) {
    new ThreadPoolWrapper(Executors.newFixedThreadPool(10));
    int i = 0;
    while(true) {
      try {
        Thread.currentThread().sleep(1000);
        System.out.println(i++);
        ThreadGroup root = Thread.currentThread().getThreadGroup().getParent();
        while (root.getParent() != null) {
          root = root.getParent();
        }
//        visit(root, 0);
      } catch (InterruptedException e) {
        throw new RuntimeException(e);
      }
    }
  }

  public static void visit(ThreadGroup group, int level) {
    // Get threads in `group'
    int numThreads = group.activeCount();
    Thread[] threads = new Thread[numThreads*2];
    numThreads = group.enumerate(threads, false);
    // Enumerate each thread in `group'
    for (int i=0; i<numThreads; i++) {
      // Get thread
      Thread thread = threads[i];
      System.out.println(thread);
    }
    // Get thread subgroups of `group'
    int numGroups = group.activeGroupCount();
    ThreadGroup[] groups = new ThreadGroup[numGroups*2];
    numGroups = group.enumerate(groups, false);
    // Recursively visit each subgroup
    for (int i=0; i<numGroups; i++) {
      visit(groups[i], level+1);
    }
  }
}
