/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.cron;

import com.google.appengine.repackaged.com.google.cron.GrocLexer;
import com.google.appengine.repackaged.com.google.cron.GrocParser;
import com.google.appengine.repackaged.org.antlr.runtime.ANTLRStringStream;
import com.google.appengine.repackaged.org.antlr.runtime.CharStream;
import com.google.appengine.repackaged.org.antlr.runtime.CommonTokenStream;
import com.google.appengine.repackaged.org.antlr.runtime.RecognitionException;
import com.google.appengine.repackaged.org.antlr.runtime.TokenSource;
import com.google.appengine.repackaged.org.antlr.runtime.TokenStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GrocTimeSpecification {
    private final Set<Integer> months;
    private final Set<Integer> ordinals;
    private final Set<Integer> weekdays;
    private final Set<Integer> monthdays;
    private final Integer interval;
    private final String intervalPeriod;
    private final int hour;
    private final int minute;
    private final int seconds;
    private final IntegerPair startHourMinute;
    private final IntegerPair endHourMinute;
    private final TimeZone timezone;
    private static final TimeZone UTC_ZONE = TimeZone.getTimeZone("UTC");
    private static final long MS_PER_HOUR = 3600000L;
    private static final long MS_PER_MINUTE = 60000L;

    public static GrocTimeSpecification create(String spec, TimeZone timezone) throws IllegalArgumentException {
        GrocLexer lexer = new GrocLexer((CharStream)new ANTLRStringStream(spec));
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        GrocParser parser = new GrocParser((TokenStream)tokens);
        parser.init();
        try {
            parser.timespec();
        }
        catch (RecognitionException e) {
            throw new IllegalArgumentException("Specification '" + spec + "' is invalid.");
        }
        if (timezone == null) {
            timezone = UTC_ZONE;
        }
        if (parser.getInterval() != null) {
            return new GrocTimeSpecification(parser.getInterval(), parser.getIntervalPeriod(), parser.getStartTime(), parser.getEndTime(), parser.getSynchronized(), timezone);
        }
        return new GrocTimeSpecification(parser.getOrdinals(), parser.getMonths(), parser.getWeekdays(), parser.getMonthdays(), parser.getTime(), timezone);
    }

    public static GrocTimeSpecification create(String spec) throws IllegalArgumentException {
        return GrocTimeSpecification.create(spec, UTC_ZONE);
    }

    public GrocTimeSpecification(Set<Integer> ordinals, Set<Integer> months, Set<Integer> weekdays, Set<Integer> monthdays, String time, TimeZone timezone) {
        this.timezone = timezone;
        this.ordinals = ordinals;
        this.months = months;
        this.weekdays = weekdays;
        this.monthdays = monthdays;
        if (!weekdays.isEmpty() && !monthdays.isEmpty()) {
            throw new IllegalArgumentException("cannot specify both monthdays and weekdays");
        }
        for (int day : monthdays) {
            if (day >= 1 && day <= 31) continue;
            throw new IllegalArgumentException("invalid day of month: " + day);
        }
        IntegerPair timeHourMinute = GrocTimeSpecification.parseTime(time);
        this.hour = timeHourMinute.first;
        this.minute = timeHourMinute.second;
        this.interval = null;
        this.seconds = 0;
        this.startHourMinute = null;
        this.endHourMinute = null;
        this.intervalPeriod = "";
    }

    public GrocTimeSpecification(int interval, String period, String startTime, String endTime, boolean synchronize, TimeZone timezone) throws IllegalArgumentException {
        this.hour = 0;
        this.minute = 0;
        this.months = new HashSet<Integer>();
        this.ordinals = new HashSet<Integer>();
        this.weekdays = new HashSet<Integer>();
        this.monthdays = new HashSet<Integer>();
        this.timezone = timezone;
        if (interval <= 0) {
            throw new IllegalArgumentException("interval must be greater than zero");
        }
        this.interval = interval;
        this.intervalPeriod = period;
        this.seconds = this.intervalPeriod.equals("hours") ? this.interval * 3600 : this.interval * 60;
        if (!startTime.isEmpty()) {
            this.startHourMinute = GrocTimeSpecification.parseTime(startTime);
            this.endHourMinute = GrocTimeSpecification.parseTime(endTime);
        } else if (synchronize) {
            if (this.seconds > 86400 || 86400 % this.seconds != 0) {
                throw new IllegalArgumentException("can only use synchronized for periods that divide evenly into 24 hours");
            }
            this.startHourMinute = new IntegerPair(0, 0);
            this.endHourMinute = new IntegerPair(23, 59);
        } else {
            this.startHourMinute = null;
            this.endHourMinute = null;
        }
    }

    private static IntegerPair parseTime(String timeString) {
        String[] elements = timeString.split(":");
        int hour = Integer.parseInt(elements[0]);
        int minute = Integer.parseInt(elements[1]);
        return new IntegerPair(hour, minute);
    }

    public List<Date> getMatches(Date start, int count) {
        ArrayList<Date> results = new ArrayList<Date>();
        Date next = start;
        for (int i = 0; i < count; ++i) {
            next = this.getMatch(next);
            results.add(next);
        }
        return results;
    }

    public Date getMatch(Date start) {
        if (this.interval != null && this.startHourMinute != null) {
            return this.getMatchRangedInterval(start);
        }
        if (this.interval != null) {
            return this.getMatchInterval(start);
        }
        return this.getMatchSpecificTime(start);
    }

    private Date getMatchRangedInterval(Date now) {
        Date startDate = this.getPreviousDate(now, this.startHourMinute);
        long startDeltaMillis = now.getTime() - startDate.getTime();
        long millis = this.seconds * 1000;
        long numIntervals = (startDeltaMillis + millis) / millis;
        long intervalMillis = startDate.getTime() + numIntervals * millis;
        Date intervalDate = new Date(intervalMillis);
        Date nextStartDate = this.getNextDate(now, this.startHourMinute);
        if (this.timeIsInRange(now) && this.timeIsInRange(intervalDate) && intervalDate.before(nextStartDate)) {
            return intervalDate;
        }
        return nextStartDate;
    }

    private boolean timeIsInRange(Date utcDate) {
        Date previousEndDate;
        Date previousStartDate = this.getPreviousDate(utcDate, this.startHourMinute);
        if (previousStartDate.after(previousEndDate = this.getPreviousDate(utcDate, this.endHourMinute))) {
            return true;
        }
        return utcDate.equals(previousEndDate);
    }

    private Date getPreviousDate(Date utcDate, IntegerPair targetHourMinute) {
        Calendar localDate = Calendar.getInstance(this.timezone);
        localDate.setTime(utcDate);
        Date result;
        while ((result = this.combineDateAndTime(localDate.get(1), localDate.get(2), localDate.get(5), targetHourMinute)).after(utcDate)) {
            localDate.add(5, -1);
        }
        return result;
    }

    private Date getNextDate(Date utcDate, IntegerPair targetHourMinute) {
        Calendar localDate = Calendar.getInstance(this.timezone);
        localDate.setTime(utcDate);
        Date result;
        while (!(result = this.combineDateAndTime(localDate.get(1), localDate.get(2), localDate.get(5), targetHourMinute)).after(utcDate)) {
            localDate.add(5, 1);
        }
        return result;
    }

    private Date combineDateAndTime(int year, int month, int day, IntegerPair hourMinute) {
        Calendar utcCalendar = Calendar.getInstance(UTC_ZONE);
        utcCalendar.set(year, month, day, hourMinute.first, hourMinute.second, 0);
        utcCalendar.set(14, 0);
        long utcMillis = utcCalendar.getTimeInMillis();
        if (this.timezone.getDSTSavings() == 0) {
            return new Date(utcMillis - (long)this.timezone.getRawOffset());
        }
        long standardMillis = utcMillis - (long)this.timezone.getRawOffset();
        long daylightMillis = standardMillis - (long)this.timezone.getDSTSavings();
        Calendar standardCalendar = Calendar.getInstance(this.timezone);
        Calendar daylightCalendar = Calendar.getInstance(this.timezone);
        standardCalendar.setTimeInMillis(standardMillis);
        daylightCalendar.setTimeInMillis(daylightMillis);
        boolean standardMatches = this.timeEquals(standardCalendar, year, month, day, hourMinute);
        boolean daylightMatches = this.timeEquals(daylightCalendar, year, month, day, hourMinute);
        if (standardMatches && daylightMatches) {
            long resultMillis = Math.min(standardMillis, daylightMillis);
            return new Date(resultMillis);
        }
        if (standardMatches) {
            return new Date(standardMillis);
        }
        if (daylightMatches) {
            return new Date(daylightMillis);
        }
        utcCalendar.set(12, 0);
        return new Date(utcCalendar.getTimeInMillis() - (long)this.timezone.getRawOffset());
    }

    private boolean timeEquals(Calendar calendar, int year, int month, int day, IntegerPair hourMinute) {
        if (calendar.get(1) != year) {
            return false;
        }
        if (calendar.get(2) != month) {
            return false;
        }
        if (calendar.get(5) != day) {
            return false;
        }
        if (calendar.get(11) != hourMinute.first) {
            return false;
        }
        if (calendar.get(12) != hourMinute.second) {
            return false;
        }
        return calendar.get(13) == 0;
    }

    private Date getMatchInterval(Date start) {
        if (this.intervalPeriod.equals("hours")) {
            return new Date(start.getTime() + (long)this.interval.intValue() * 3600000L);
        }
        return new Date(start.getTime() + (long)this.interval.intValue() * 60000L);
    }

    private Date getMatchSpecificTime(Date start) {
        List<Integer> dayMatches;
        int yearWraps;
        int nextMonth;
        Calendar calendar = Calendar.getInstance(this.timezone);
        calendar.setTime(start);
        int startYear = calendar.get(1);
        int startMonth = calendar.get(2) + 1;
        int startDayOfMonth = calendar.get(5);
        int startHour = calendar.get(11);
        int startMinute = calendar.get(12);
        int MAX_MONTHS_TO_CONSIDER = 48;
        NextGenerator monthGen = new NextGenerator(startMonth, this.months);
        int monthsConsidered = 0;
        while (true) {
            IntegerPair nextMonthWrapPair = monthGen.next();
            nextMonth = nextMonthWrapPair.first;
            yearWraps = nextMonthWrapPair.second;
            ++monthsConsidered;
            calendar.set(startYear + yearWraps, nextMonth - 1, 1);
            dayMatches = this.findDays(calendar);
            if (dayMatches.size() == 0) {
                if (monthsConsidered >= 48) {
                    throw new AssertionError((Object)"no matching days");
                }
                continue;
            }
            if (calendar.get(1) == startYear && nextMonth == startMonth) {
                while (!dayMatches.isEmpty() && dayMatches.get(0) < startDayOfMonth) {
                    dayMatches.remove(0);
                }
                if (!dayMatches.isEmpty() && dayMatches.get(0) == startDayOfMonth && (startHour > this.hour || startHour == this.hour && startMinute >= this.minute)) {
                    dayMatches.remove(0);
                }
            }
            if (!dayMatches.isEmpty()) break;
        }
        int candidateDay = dayMatches.get(0);
        dayMatches.remove(0);
        calendar.set(startYear + yearWraps, nextMonth - 1, candidateDay, this.hour, this.minute, 0);
        return calendar.getTime();
    }

    List<Integer> findDays(Calendar candidate) {
        TreeSet<Integer> outDays = new TreeSet<Integer>();
        long original = candidate.getTimeInMillis();
        candidate.set(5, 1);
        int firstWeekDay = candidate.get(7) - 1;
        candidate.set(2, candidate.get(2) + 1);
        candidate.add(5, -1);
        int lastDayOfMonth = candidate.get(5);
        candidate.setTimeInMillis(original);
        if (this.monthdays.isEmpty()) {
            for (int ordinal : this.ordinals) {
                for (int weekday : this.weekdays) {
                    int day = (7 + weekday - firstWeekDay) % 7 + 1;
                    if ((day += 7 * (ordinal - 1)) > lastDayOfMonth) continue;
                    outDays.add(day);
                }
            }
        } else {
            for (int day : this.monthdays) {
                if (day > lastDayOfMonth) continue;
                outDays.add(day);
            }
        }
        return new ArrayList<Integer>(outDays);
    }

    static class IntegerPair {
        public final int first;
        public final int second;

        IntegerPair(int first, int second) {
            this.first = first;
            this.second = second;
        }

        public boolean equals(Object other) {
            return other instanceof IntegerPair && this.first == ((IntegerPair)other).first && this.second == ((IntegerPair)other).second;
        }

        public int hashCode() {
            return this.first ^ this.second;
        }

        public String toString() {
            return "<" + this.first + "," + this.second + ">";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class NextGenerator {
        private int start;
        private final Set<Integer> matches;
        private List<Integer> remaining;
        private int wrapcount;

        NextGenerator(Integer start, Set<Integer> matches) {
            this.start = start;
            this.matches = new TreeSet<Integer>(matches);
            this.remaining = new ArrayList<Integer>(this.matches);
            this.wrapcount = 0;
        }

        public IntegerPair next() {
            while (this.remaining.size() > 0 && this.remaining.get(0) < this.start) {
                this.remaining.remove(0);
            }
            if (this.remaining.size() == 0) {
                this.remaining = new ArrayList<Integer>(this.matches);
                ++this.wrapcount;
            }
            this.start = this.remaining.get(0);
            this.remaining.remove(0);
            return new IntegerPair(this.start, this.wrapcount);
        }
    }
}

