/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.development;

import com.google.appengine.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.appengine.tools.development.BackendServers;
import com.google.apphosting.api.ApiProxy;
import java.io.IOException;
import java.util.Map;
import java.util.logging.Logger;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class BackendServersFilter
implements Filter {
    static final String BACKEND_REDIRECT_ATTRIBUTE = "com.google.appengine.backend.BackendName";
    static final String INSTANCE_REDIRECT_ATTRIBUTE = "com.google.appengine.backend.BackendInstance";
    static final int SERVER_BUSY_ERROR_CODE = 500;
    static final int SERVER_STOPPED_ERROR_CODE = 404;
    static final int SERVER_MISSING_ERROR_CODE = 502;
    private final BackendServers backendServersManager;
    private Logger logger = Logger.getLogger(BackendServersFilter.class.getName());

    @VisibleForTesting
    BackendServersFilter(BackendServers backendServers) {
        this.backendServersManager = backendServers;
    }

    public BackendServersFilter() {
        this.backendServersManager = BackendServers.getInstance();
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest hrequest = (HttpServletRequest)request;
        HttpServletResponse hresponse = (HttpServletResponse)response;
        RequestType requestType = this.getRequestType(hrequest);
        this.logger.finer("got request, type=" + (Object)((Object)requestType));
        switch (requestType) {
            case NORMAL_REQUEST: {
                this.injectServerApiInfo(null, -1);
                chain.doFilter((ServletRequest)hrequest, (ServletResponse)hresponse);
                break;
            }
            case REDIRECT_REQUESTED: {
                this.doServerRedirect(hrequest, hresponse);
                break;
            }
            case DIRECT_SERVER_REQUEST: {
                this.doDirectServerRequest(hrequest, hresponse, chain);
                break;
            }
            case REDIRECTED_SERVER_REQUEST: {
                this.doRedirectedServerRequest(hrequest, hresponse, chain);
                break;
            }
            case SERVER_STARTUP_REQUEST: {
                this.doStartupRequest(hrequest, hresponse, chain);
            }
        }
    }

    @VisibleForTesting
    RequestType getRequestType(HttpServletRequest hrequest) {
        int serverPort = hrequest.getServerPort();
        String directServerName = this.backendServersManager.getServerNameFromPort(serverPort);
        if (hrequest.getRequestURI().equals("/_ah/start") && directServerName != null) {
            return RequestType.SERVER_STARTUP_REQUEST;
        }
        if (hrequest.getAttribute(BACKEND_REDIRECT_ATTRIBUTE) != null && hrequest.getAttribute(BACKEND_REDIRECT_ATTRIBUTE) instanceof String) {
            return RequestType.REDIRECTED_SERVER_REQUEST;
        }
        if (directServerName != null) {
            int directServerReplica = this.backendServersManager.getServerInstanceFromPort(serverPort);
            if (directServerReplica == -1) {
                return RequestType.REDIRECT_REQUESTED;
            }
            return RequestType.DIRECT_SERVER_REQUEST;
        }
        String serverRedirectHeader = BackendServersFilter.getHeaderOrParameter(hrequest, "X-AppEngine-BackendName");
        if (serverRedirectHeader == null) {
            return RequestType.NORMAL_REQUEST;
        }
        return RequestType.REDIRECT_REQUESTED;
    }

    private boolean instanceAcceptsConnections(String requestedServer, int instance, HttpServletResponse hresponse) throws IOException {
        if (!this.backendServersManager.checkInstanceExists(requestedServer, instance)) {
            String msg = String.format("Got request to non-configured instance: %d.%s", instance, requestedServer);
            this.logger.warning(msg);
            hresponse.sendError(502, msg);
            return false;
        }
        if (this.backendServersManager.checkInstanceStopped(requestedServer, instance)) {
            String msg = String.format("Got request to stopped instance: %d.%s", instance, requestedServer);
            this.logger.warning(msg);
            hresponse.sendError(404, msg);
            return false;
        }
        if (!this.backendServersManager.acquireServingPermit(requestedServer, instance, true)) {
            String msg = String.format("Got request to server %d.%s but the instance is busy.", instance, requestedServer);
            this.logger.finer(msg);
            hresponse.sendError(500, msg);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doServerRedirect(HttpServletRequest hrequest, HttpServletResponse hresponse) throws IOException, ServletException {
        String requestedServer = this.backendServersManager.getServerNameFromPort(hrequest.getServerPort());
        if (requestedServer == null) {
            requestedServer = BackendServersFilter.getHeaderOrParameter(hrequest, "X-AppEngine-BackendName");
        }
        int instance = BackendServersFilter.getInstanceIdFromRequest(hrequest);
        this.logger.finest(String.format("redirect request to server: %d.%s", instance, requestedServer));
        if (instance != -1) {
            if (!this.instanceAcceptsConnections(requestedServer, instance, hresponse)) {
                return;
            }
        } else {
            if (!this.backendServersManager.checkServerExists(requestedServer)) {
                String msg = String.format("Got request to non-configured server: %s", requestedServer);
                this.logger.warning(msg);
                hresponse.sendError(502, msg);
                return;
            }
            if (this.backendServersManager.checkServerStopped(requestedServer)) {
                String msg = String.format("Got request to stopped server: %s", requestedServer);
                this.logger.warning(msg);
                hresponse.sendError(404, msg);
                return;
            }
            instance = this.backendServersManager.getAndReserveFreeInstance(requestedServer);
            if (instance == -1) {
                String msg = String.format("all instances of server %s are busy", requestedServer);
                this.logger.finest(msg);
                hresponse.sendError(500, msg);
                return;
            }
        }
        try {
            this.logger.finer(String.format("forwarding request to server: %d.%s", instance, requestedServer));
            hrequest.setAttribute(BACKEND_REDIRECT_ATTRIBUTE, (Object)requestedServer);
            hrequest.setAttribute(INSTANCE_REDIRECT_ATTRIBUTE, (Object)instance);
            this.backendServersManager.forwardToServer(requestedServer, instance, hrequest, hresponse);
        }
        finally {
            this.backendServersManager.returnServingPermit(requestedServer, instance);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doDirectServerRequest(HttpServletRequest hrequest, HttpServletResponse hresponse, FilterChain chain) throws IOException, ServletException {
        int serverPort = hrequest.getServerPort();
        String requestedServer = this.backendServersManager.getServerNameFromPort(serverPort);
        int instance = this.backendServersManager.getServerInstanceFromPort(serverPort);
        this.logger.finest("request to specific server instance: " + instance + "." + requestedServer);
        if (!this.instanceAcceptsConnections(requestedServer, instance, hresponse)) {
            return;
        }
        try {
            this.injectServerApiInfo(requestedServer, instance);
            chain.doFilter((ServletRequest)hrequest, (ServletResponse)hresponse);
        }
        finally {
            this.backendServersManager.returnServingPermit(requestedServer, instance);
        }
    }

    private void doRedirectedServerRequest(HttpServletRequest hrequest, HttpServletResponse hresponse, FilterChain chain) throws IOException, ServletException {
        Object backendServerValue = hrequest.getAttribute(BACKEND_REDIRECT_ATTRIBUTE);
        String backendServer = backendServerValue instanceof String ? (String)backendServerValue : null;
        Object instanceValue = hrequest.getAttribute(INSTANCE_REDIRECT_ATTRIBUTE);
        Integer instance = instanceValue instanceof Integer ? (Integer)instanceValue : null;
        this.logger.finest("redirected request to server instance: " + instance + "." + backendServer);
        this.injectServerApiInfo(backendServer, instance);
        chain.doFilter((ServletRequest)hrequest, (ServletResponse)hresponse);
    }

    private void doStartupRequest(HttpServletRequest hrequest, HttpServletResponse hresponse, FilterChain chain) throws IOException, ServletException {
        int serverPort = hrequest.getServerPort();
        String backendServer = this.backendServersManager.getServerNameFromPort(serverPort);
        int instance = this.backendServersManager.getServerInstanceFromPort(serverPort);
        this.logger.finest("startup request to: " + instance + "." + backendServer);
        this.injectServerApiInfo(backendServer, instance);
        chain.doFilter((ServletRequest)hrequest, (ServletResponse)hresponse);
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    private void injectServerApiInfo(String currentServer, int instance) {
        Map threadLocalAttributes = ApiProxy.getCurrentEnvironment().getAttributes();
        threadLocalAttributes.put("com.google.appengine.instance.id", instance + "");
        if (currentServer != null) {
            threadLocalAttributes.put("com.google.appengine.backend.id", currentServer);
        }
        Map<String, String> portMapping = this.backendServersManager.getPortMapping();
        threadLocalAttributes.put("com.google.appengine.devappserver.portmapping", portMapping);
        if (portMapping.size() > 0) {
            threadLocalAttributes.put("com.google.appengine.dev.backend_controller", this.backendServersManager);
        }
    }

    @VisibleForTesting
    static String getHeaderOrParameter(HttpServletRequest request, String key) {
        String value = request.getHeader(key);
        if (value != null) {
            return value;
        }
        return request.getParameter(key);
    }

    @VisibleForTesting
    static int getInstanceIdFromRequest(HttpServletRequest request) {
        try {
            return Integer.parseInt(BackendServersFilter.getHeaderOrParameter(request, "X-AppEngine-BackendInstance"));
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @VisibleForTesting
    static enum RequestType {
        NORMAL_REQUEST,
        REDIRECT_REQUESTED,
        DIRECT_SERVER_REQUEST,
        REDIRECTED_SERVER_REQUEST,
        SERVER_STARTUP_REQUEST;

    }
}

