/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.development;

import com.google.appengine.tools.development.StreamHandlerFactory;
import com.google.apphosting.api.ApiProxy;
import com.google.apphosting.utils.security.urlfetch.URLFetchServiceStreamHandler;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;

public class LocalURLFetchServiceStreamHandler
extends URLFetchServiceStreamHandler {
    private final URLStreamHandler fallbackHandler;
    private final Method openConnection1Arg;
    private final Method openConnection2Arg;

    public LocalURLFetchServiceStreamHandler(URLStreamHandler fallbackHandler) {
        this.fallbackHandler = fallbackHandler;
        this.openConnection1Arg = StreamHandlerFactory.getDeclaredMethod(fallbackHandler.getClass(), "openConnection", URL.class);
        this.openConnection2Arg = StreamHandlerFactory.getDeclaredMethod(fallbackHandler.getClass(), "openConnection", URL.class, Proxy.class);
    }

    protected HttpURLConnection openConnection(URL u) throws IOException {
        if (this.fallbackHandler != null && ApiProxy.getDelegate() == null) {
            return (HttpURLConnection)StreamHandlerFactory.invoke(this.fallbackHandler, this.openConnection1Arg, u);
        }
        return super.openConnection(u);
    }

    protected URLConnection openConnection(URL u, Proxy p) throws IOException {
        if (this.fallbackHandler != null && ApiProxy.getDelegate() == null) {
            return (HttpURLConnection)StreamHandlerFactory.invoke(this.fallbackHandler, this.openConnection2Arg, u, p);
        }
        return super.openConnection(u, p);
    }

    public URLStreamHandler getFallbackHandler() {
        return this.fallbackHandler;
    }
}

