/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.utils.jetty;

import com.google.appengine.tools.info.SdkInfo;
import com.google.apphosting.utils.io.IoUtil;
import com.google.apphosting.utils.jetty.AppEngineWebAppContext;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mortbay.jetty.security.ConstraintMapping;

public class DevAppEngineWebAppContext
extends AppEngineWebAppContext {
    private static final Logger logger = Logger.getLogger(DevAppEngineWebAppContext.class.getName());
    private static final String JASPER_SERVLET_CLASSPATH = "org.apache.catalina.jsp_classpath";
    private static final String X_GOOGLE_DEV_APPSERVER_SKIPADMINCHECK = "X-Google-DevAppserver-SkipAdminCheck";
    private static final String SKIP_ADMIN_CHECK_ATTR = "com.google.apphosting.internal.SkipAdminCheck";
    private final Object transportGuaranteeLock = new Object();
    private boolean transportGuaranteesDisabled = false;

    public DevAppEngineWebAppContext(File appDir, String serverInfo) {
        super(appDir, serverInfo);
        this.setAttribute(JASPER_SERVLET_CLASSPATH, this.buildClasspath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(String target, HttpServletRequest request, HttpServletResponse response, int dispatch) throws IOException, ServletException {
        if (this.hasSkipAdminCheck(request)) {
            request.setAttribute(SKIP_ADMIN_CHECK_ATTR, (Object)Boolean.TRUE);
        }
        this.disableTransportGuarantee();
        System.setProperty("devappserver-thread-" + Thread.currentThread().getName(), "true");
        try {
            super.handle(target, request, response, dispatch);
        }
        finally {
            System.clearProperty("devappserver-thread-" + Thread.currentThread().getName());
        }
    }

    private boolean hasSkipAdminCheck(HttpServletRequest request) {
        Enumeration headerNames = request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String name = (String)headerNames.nextElement();
            if (!name.equalsIgnoreCase(X_GOOGLE_DEV_APPSERVER_SKIPADMINCHECK)) continue;
            return true;
        }
        return false;
    }

    private String buildClasspath() {
        StringBuffer classpath = new StringBuffer();
        for (File f : SdkInfo.getSharedLibFiles()) {
            classpath.append(f.getAbsolutePath());
            classpath.append(File.pathSeparatorChar);
        }
        String webAppPath = this.getWar();
        classpath.append(webAppPath + File.separator + "classes" + File.pathSeparatorChar);
        List<File> files = IoUtil.getFilesAndDirectories(new File(webAppPath, "lib"));
        for (File f : files) {
            if (!f.isFile() || !f.getName().endsWith(".jar")) continue;
            classpath.append(f.getAbsolutePath());
            classpath.append(File.pathSeparatorChar);
        }
        return classpath.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disableTransportGuarantee() {
        Object object = this.transportGuaranteeLock;
        synchronized (object) {
            ConstraintMapping[] mappings;
            if (!this.transportGuaranteesDisabled && this.getSecurityHandler() != null && (mappings = this.getSecurityHandler().getConstraintMappings()) != null) {
                for (ConstraintMapping mapping : mappings) {
                    if (mapping.getConstraint().getDataConstraint() <= 0) continue;
                    logger.info("Ignoring <transport-guarantee> for " + mapping.getPathSpec() + " as the SDK does not support HTTPS.  It will still be used" + " when you upload your application.");
                    mapping.getConstraint().setDataConstraint(0);
                }
            }
            this.transportGuaranteesDisabled = true;
        }
    }
}

