/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.remoteapi;

import com.google.appengine.api.urlfetch.FetchOptions;
import com.google.appengine.api.urlfetch.HTTPHeader;
import com.google.appengine.api.urlfetch.HTTPMethod;
import com.google.appengine.api.urlfetch.HTTPRequest;
import com.google.appengine.api.urlfetch.HTTPResponse;
import com.google.appengine.api.urlfetch.URLFetchService;
import com.google.appengine.api.urlfetch.URLFetchServiceFactory;
import com.google.appengine.repackaged.org.apache.commons.httpclient.Cookie;
import com.google.appengine.repackaged.org.apache.commons.httpclient.cookie.CookieSpecBase;
import com.google.appengine.tools.remoteapi.AppEngineClient;
import com.google.appengine.tools.remoteapi.ClientLogin;
import com.google.appengine.tools.remoteapi.HostedAppEngineClient;
import com.google.appengine.tools.remoteapi.LoginException;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HostedClientLogin
extends ClientLogin {
    private final URLFetchService fetchService = URLFetchServiceFactory.getURLFetchService();

    @Override
    ClientLogin.PostResponse executePost(String urlStr, List<String[]> postParams) throws IOException {
        URL url = new URL(urlStr);
        StringBuilder payload = new StringBuilder();
        for (String[] param : postParams) {
            payload.append(String.format("%s=%s&", param[0], param[1]));
        }
        payload.setLength(payload.length() - 1);
        HTTPRequest req = new HTTPRequest(url, HTTPMethod.POST);
        req.setPayload(payload.toString().getBytes());
        HTTPResponse resp = this.fetchService.fetch(req);
        AppEngineClient.Response response = HostedAppEngineClient.createResponse(resp);
        return new ClientLogin.PostResponse(resp.getResponseCode(), response.getBodyAsString());
    }

    @Override
    List<Cookie> getAppEngineLoginCookies(String urlStr) throws IOException {
        URL url = new URL(urlStr);
        FetchOptions fetchOptions = FetchOptions.Builder.doNotFollowRedirects();
        HTTPRequest req = new HTTPRequest(url, HTTPMethod.GET, fetchOptions);
        HTTPResponse resp = this.fetchService.fetch(req);
        if (resp.getResponseCode() != 302) {
            throw new LoginException("unexpected response from app engine: " + resp.getResponseCode());
        }
        ArrayList<Cookie> cookies = new ArrayList<Cookie>();
        for (HTTPHeader header : resp.getHeaders()) {
            if (!header.getName().toLowerCase().equals("set-cookie")) continue;
            CookieSpecBase spec = new CookieSpecBase();
            cookies.addAll(Arrays.asList(spec.parse(url.getHost(), url.getPort() == -1 ? 0 : url.getPort(), url.getPath(), url.getProtocol().equals("https"), header.getValue())));
        }
        return cookies;
    }
}

