/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.remoteapi;

import com.google.appengine.repackaged.org.apache.commons.httpclient.Cookie;
import com.google.appengine.repackaged.org.apache.commons.httpclient.HttpClient;
import com.google.appengine.repackaged.org.apache.commons.httpclient.HttpMethodBase;
import com.google.appengine.repackaged.org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import com.google.appengine.repackaged.org.apache.commons.httpclient.methods.ByteArrayRequestEntity;
import com.google.appengine.repackaged.org.apache.commons.httpclient.methods.GetMethod;
import com.google.appengine.repackaged.org.apache.commons.httpclient.methods.PostMethod;
import com.google.appengine.tools.remoteapi.AppEngineClient;
import com.google.appengine.tools.remoteapi.RemoteApiOptions;
import java.io.IOException;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class StandaloneAppEngineClient
extends AppEngineClient {
    private final HttpClient httpClient;

    StandaloneAppEngineClient(RemoteApiOptions options, List<Cookie> authCookies, String appId) {
        super(options, authCookies, appId);
        HttpClient httpClient = new HttpClient(new MultiThreadedHttpConnectionManager());
        httpClient.getState().addCookies(this.getAuthCookies());
        this.httpClient = httpClient;
    }

    @Override
    AppEngineClient.Response get(String path) throws IOException {
        GetMethod method = new GetMethod(this.makeUrl(path));
        method.setFollowRedirects(false);
        this.addHeaders(method, this.getHeadersForGet());
        this.httpClient.executeMethod(method);
        return this.createResponse(method);
    }

    @Override
    AppEngineClient.Response post(String path, String mimeType, byte[] body) throws IOException {
        PostMethod post = new PostMethod(this.makeUrl(path));
        post.setFollowRedirects(false);
        this.addHeaders(post, this.getHeadersForPost(mimeType));
        post.setRequestEntity(new ByteArrayRequestEntity(body));
        this.httpClient.executeMethod(post);
        return this.createResponse(post);
    }

    private void addHeaders(HttpMethodBase method, List<String[]> headers) {
        for (String[] headerPair : headers) {
            method.addRequestHeader(headerPair[0], headerPair[1]);
        }
    }

    private AppEngineClient.Response createResponse(HttpMethodBase method) throws IOException {
        byte[] body = method.getResponseBody(this.getMaxResponseSize());
        return new AppEngineClient.Response(method.getStatusCode(), body, method.getResponseCharSet());
    }
}

