/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.remoteapi;

import com.google.appengine.repackaged.org.apache.commons.httpclient.Cookie;
import com.google.appengine.repackaged.org.apache.commons.httpclient.HttpClient;
import com.google.appengine.repackaged.org.apache.commons.httpclient.methods.GetMethod;
import com.google.appengine.repackaged.org.apache.commons.httpclient.methods.PostMethod;
import com.google.appengine.tools.remoteapi.ClientLogin;
import com.google.appengine.tools.remoteapi.LoginException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class StandaloneClientLogin
extends ClientLogin {
    private static final int MAX_RESPONSE_SIZE = 0x100000;

    StandaloneClientLogin() {
    }

    @Override
    ClientLogin.PostResponse executePost(String url, List<String[]> postParams) throws IOException {
        PostMethod post = new PostMethod(url);
        for (String[] param : postParams) {
            post.addParameter(param[0], param[1]);
        }
        HttpClient client = new HttpClient();
        client.executeMethod(post);
        String body = post.getResponseBodyAsString(0x100000);
        return new ClientLogin.PostResponse(post.getStatusCode(), body);
    }

    @Override
    List<Cookie> getAppEngineLoginCookies(String url) throws IOException {
        GetMethod get = new GetMethod(url);
        get.setFollowRedirects(false);
        HttpClient client = new HttpClient();
        client.executeMethod(get);
        if (get.getStatusCode() == 302) {
            return new ArrayList<Cookie>(Arrays.asList(client.getState().getCookies()));
        }
        throw new LoginException("unexpected response from app engine: " + get.getStatusCode());
    }
}

