/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.development.testing;

import com.google.appengine.api.NamespaceManager;
import com.google.appengine.tools.development.ApiProxyLocal;
import com.google.appengine.tools.development.ApiProxyLocalFactory;
import com.google.appengine.tools.development.Clock;
import com.google.appengine.tools.development.LocalRpcService;
import com.google.appengine.tools.development.LocalServerEnvironment;
import com.google.appengine.tools.development.testing.LocalServiceTestConfig;
import com.google.appengine.tools.development.testing.TestLocalServerEnvironment;
import com.google.apphosting.api.ApiProxy;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalServiceTestHelper {
    private static final String APPS_NAMESPACE_KEY = NamespaceManager.class.getName() + ".appsNamespace";
    static final String DEFAULT_APP_ID = "test";
    static final String DEFAULT_VERSION_ID = "1.0";
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private final List<LocalServiceTestConfig> configs;
    private String envAppId = "test";
    private String envVersionId = "1.0";
    private String envEmail;
    private boolean envIsLoggedIn;
    private boolean envIsAdmin;
    private String envAuthDomain;
    private Map<String, Object> envAttributes = new HashMap<String, Object>();
    private Clock clock;
    private boolean enforceApiDeadlines = false;
    private boolean simulateProdLatencies = false;
    private TimeZone timeZone = TimeZone.getTimeZone("UTC");
    private TimeZone originalDefaultTimeZone;

    public LocalServiceTestHelper(LocalServiceTestConfig ... configs) {
        this.configs = Arrays.asList(configs);
    }

    public LocalServiceTestHelper setEnvAppId(String envAppId) {
        this.envAppId = envAppId;
        return this;
    }

    public LocalServiceTestHelper setEnvVersionId(String envVersionId) {
        this.envVersionId = envVersionId;
        return this;
    }

    public LocalServiceTestHelper setEnvEmail(String envEmail) {
        this.envEmail = envEmail;
        return this;
    }

    public LocalServiceTestHelper setEnvIsLoggedIn(boolean envIsLoggedIn) {
        this.envIsLoggedIn = envIsLoggedIn;
        return this;
    }

    public LocalServiceTestHelper setEnvIsAdmin(boolean envIsAdmin) {
        this.envIsAdmin = envIsAdmin;
        return this;
    }

    public LocalServiceTestHelper setEnvAuthDomain(String envAuthDomain) {
        this.envAuthDomain = envAuthDomain;
        return this;
    }

    public LocalServiceTestHelper setEnvRequestNamespace(String envRequestNamespace) {
        this.envAttributes.put(APPS_NAMESPACE_KEY, envRequestNamespace);
        return this;
    }

    public LocalServiceTestHelper setEnvAttributes(Map<String, Object> envAttributes) {
        this.envAttributes = envAttributes;
        return this;
    }

    public LocalServiceTestHelper setClock(Clock clock) {
        this.clock = clock;
        return this;
    }

    public LocalServiceTestHelper setEnforceApiDeadlines(boolean val) {
        this.enforceApiDeadlines = val;
        return this;
    }

    public LocalServiceTestHelper setSimulateProdLatencies(boolean val) {
        this.simulateProdLatencies = val;
        return this;
    }

    public LocalServiceTestHelper setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
        return this;
    }

    public final LocalServiceTestHelper setUp() {
        this.originalDefaultTimeZone = TimeZone.getDefault();
        TimeZone.setDefault(this.timeZone);
        ApiProxy.setEnvironmentForCurrentThread(this.newEnvironment());
        ApiProxyLocal proxyLocal = new ApiProxyLocalFactory().create(this.newLocalServerEnvironment());
        if (this.clock != null) {
            proxyLocal.setClock(this.clock);
        }
        ApiProxy.setDelegate(proxyLocal);
        for (LocalServiceTestConfig config : this.configs) {
            config.setUp();
        }
        return this;
    }

    protected ApiProxy.Environment newEnvironment() {
        return new TestEnvironment(){

            @Override
            public String getAppId() {
                return LocalServiceTestHelper.this.envAppId;
            }

            @Override
            public String getVersionId() {
                return LocalServiceTestHelper.this.envVersionId;
            }

            @Override
            public String getEmail() {
                return LocalServiceTestHelper.this.envEmail;
            }

            @Override
            public boolean isLoggedIn() {
                return LocalServiceTestHelper.this.envIsLoggedIn;
            }

            @Override
            public boolean isAdmin() {
                return LocalServiceTestHelper.this.envIsAdmin;
            }

            @Override
            public String getAuthDomain() {
                return LocalServiceTestHelper.this.envAuthDomain;
            }

            @Override
            public Map<String, Object> getAttributes() {
                return LocalServiceTestHelper.this.envAttributes;
            }
        };
    }

    static ApiProxy.Environment copyEnvironment(ApiProxy.Environment copyFrom) {
        return new TestEnvironment(copyFrom);
    }

    static ApiProxy.Environment newDefaultTestEnvironment() {
        return new TestEnvironment();
    }

    protected LocalServerEnvironment newLocalServerEnvironment() {
        return new TestLocalServerEnvironment(this.enforceApiDeadlines, this.simulateProdLatencies);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void tearDown() {
        try {
            RuntimeException firstException = null;
            for (LocalServiceTestConfig config : this.configs) {
                try {
                    config.tearDown();
                }
                catch (RuntimeException rte) {
                    if (firstException == null) {
                        firstException = rte;
                        continue;
                    }
                    this.logger.log(Level.SEVERE, "Received exception tearing down config of type " + config.getClass().getName(), rte);
                }
            }
            if (firstException != null) {
                throw firstException;
            }
            ApiProxy.setDelegate(null);
            ApiProxy.setEnvironmentForCurrentThread(null);
        }
        finally {
            TimeZone.setDefault(this.originalDefaultTimeZone);
        }
    }

    public static ApiProxyLocal getApiProxyLocal() {
        return (ApiProxyLocal)ApiProxy.getDelegate();
    }

    public static LocalRpcService getLocalService(String serviceName) {
        return LocalServiceTestHelper.getApiProxyLocal().getService(serviceName);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TestEnvironment
    implements ApiProxy.Environment {
        private String appId = "test";
        private String versionId = "1.0";
        private String email;
        private boolean isLoggedIn;
        private boolean isAdmin;
        private String authDomain;
        private Map<String, Object> attributes = new HashMap<String, Object>();

        private TestEnvironment() {
        }

        private TestEnvironment(String appId, String versionId, String email, boolean isLoggedIn, boolean isAdmin, String authDomain, Map<String, Object> attributes) {
            this.appId = appId;
            this.versionId = versionId;
            this.email = email;
            this.isLoggedIn = isLoggedIn;
            this.isAdmin = isAdmin;
            this.authDomain = authDomain;
            this.attributes = attributes;
        }

        public TestEnvironment(ApiProxy.Environment copyFrom) {
            this(copyFrom.getAppId(), copyFrom.getVersionId(), copyFrom.getEmail(), copyFrom.isLoggedIn(), copyFrom.isAdmin(), copyFrom.getAuthDomain(), new HashMap<String, Object>(copyFrom.getAttributes()));
        }

        @Override
        public String getAppId() {
            return this.appId;
        }

        @Override
        public String getVersionId() {
            return this.versionId;
        }

        @Override
        public String getEmail() {
            return this.email;
        }

        @Override
        public boolean isLoggedIn() {
            return this.isLoggedIn;
        }

        @Override
        public boolean isAdmin() {
            return this.isAdmin;
        }

        @Override
        public String getAuthDomain() {
            return this.authDomain;
        }

        @Override
        @Deprecated
        public String getRequestNamespace() {
            throw new IllegalArgumentException("getRequestNamespace() is no longer supported. Use NamespaceManager.getGoogleAppsDomain() instead.");
        }

        @Override
        public Map<String, Object> getAttributes() {
            return this.attributes;
        }
    }
}

