/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.utils.glob;

import com.google.apphosting.utils.glob.Glob;
import java.util.regex.Pattern;

abstract class AbstractGlob
implements Glob {
    private static final String SENTINEL_VALUE = "_-= (S3Nt!N\\$L) =-_";
    protected final String pattern;

    public AbstractGlob(String pattern) {
        this.pattern = pattern;
    }

    public String getPattern() {
        return this.pattern;
    }

    public boolean isLiteral() {
        return this.pattern.indexOf("*") == -1;
    }

    public Pattern getRegularExpression() {
        String regex = this.pattern;
        regex = regex.replaceAll("([^A-Za-z0-9\\-_/])", "\\\\$1");
        regex = regex.replaceAll("\\\\\\*", ".*");
        return Pattern.compile(regex);
    }

    public boolean matches(String string) {
        return this.getRegularExpression().matcher(string).matches();
    }

    public boolean matchesAll(Glob glob) {
        return this.matchesAll(glob.getPattern());
    }

    public boolean matchesAll(String pattern) {
        return this.matches(pattern.replaceAll("\\*", SENTINEL_VALUE));
    }

    public boolean equals(Object object) {
        if (object instanceof AbstractGlob) {
            AbstractGlob glob = (AbstractGlob)object;
            return this.pattern.equals(glob.pattern);
        }
        return false;
    }

    public int hashCode() {
        return this.pattern.hashCode();
    }

    public String toString() {
        return this.pattern;
    }
}

