/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.development.agent.impl;

import com.google.appengine.repackaged.org.objectweb.asm.ClassAdapter;
import com.google.appengine.repackaged.org.objectweb.asm.ClassVisitor;
import com.google.appengine.repackaged.org.objectweb.asm.MethodVisitor;
import com.google.appengine.repackaged.org.objectweb.asm.commons.GeneratorAdapter;
import com.google.appengine.tools.development.agent.impl.BlackList;

public class ObjectAccessVisitor
extends ClassAdapter {
    private static final String REJECT = "reject";
    private static final String REJECT_DESCRIPTOR = "(Ljava/lang/String;)V";

    public ObjectAccessVisitor(ClassVisitor classVisitor) {
        super(classVisitor);
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
        return mv == null ? null : new MethodTranslator(mv, access, name, desc);
    }

    private class MethodTranslator
    extends GeneratorAdapter {
        MethodTranslator(MethodVisitor methodVisitor, int access, String name, String desc) {
            super(methodVisitor, access, name, desc);
        }

        public void visitFieldInsn(int opcode, String owner, String name, String desc) {
            this.maybeReject(owner);
            super.visitFieldInsn(opcode, owner, name, desc);
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc) {
            this.maybeReject(owner);
            super.visitMethodInsn(opcode, owner, name, desc);
        }

        private void maybeReject(String klass) {
            if (BlackList.getBlackList().contains(klass)) {
                super.push(klass.replace('/', '.'));
                super.visitMethodInsn(184, "com/google/appengine/tools/development/agent/runtime/Runtime", ObjectAccessVisitor.REJECT, ObjectAccessVisitor.REJECT_DESCRIPTOR);
            }
        }
    }
}

