/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.development.agent.impl;

import com.google.appengine.repackaged.org.objectweb.asm.ClassAdapter;
import com.google.appengine.repackaged.org.objectweb.asm.ClassVisitor;
import com.google.appengine.repackaged.org.objectweb.asm.MethodVisitor;
import com.google.appengine.repackaged.org.objectweb.asm.Type;
import com.google.appengine.repackaged.org.objectweb.asm.commons.GeneratorAdapter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ReflectionVisitor
extends ClassAdapter {
    private static final Map<String, Set<String>> interceptedMethods = new HashMap<String, Set<String>>();

    public ReflectionVisitor(ClassVisitor classVisitor) {
        super(classVisitor);
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
        return mv == null ? null : new MethodTranslator(mv, access, name, desc);
    }

    static {
        interceptedMethods.put("java/lang/reflect/Method", new HashSet<String>(Arrays.asList("invoke")));
        interceptedMethods.put("java/lang/reflect/Field", new HashSet<String>(Arrays.asList("get", "getBoolean", "getByte", "getChar", "getDouble", "getFloat", "getInt", "getLong", "getShort", "set", "setBoolean", "setByte", "setChar", "setDouble", "setFloat", "setInt", "setLong", "setShort")));
        interceptedMethods.put("java/lang/reflect/Constructor", new HashSet<String>(Arrays.asList("newInstance")));
        interceptedMethods.put("java/lang/Class", new HashSet<String>(Arrays.asList("newInstance")));
    }

    private class MethodTranslator
    extends GeneratorAdapter {
        MethodTranslator(MethodVisitor methodVisitor, int access, String name, String desc) {
            super(methodVisitor, access, name, desc);
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc) {
            Set methods = (Set)interceptedMethods.get(owner);
            if (methods == null || !methods.contains(name)) {
                super.visitMethodInsn(opcode, owner, name, desc);
                return;
            }
            String newDesc = desc;
            if (opcode == 182) {
                Type[] argTypes = Type.getArgumentTypes(desc);
                Type[] newArgTypes = new Type[argTypes.length + 1];
                newArgTypes[0] = Type.getType("L" + owner + ";");
                System.arraycopy(argTypes, 0, newArgTypes, 1, argTypes.length);
                newDesc = Type.getMethodDescriptor(Type.getReturnType(desc), newArgTypes);
            }
            super.visitMethodInsn(184, "com/google/appengine/tools/development/agent/runtime/Runtime", name, newDesc);
        }
    }
}

