/**********************************************************************
Copyright (c) 2007 Andy Jefferson and others. All rights reserved.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
 

Contributors:
    ...
**********************************************************************/
package org.datanucleus.store.mapped.expression;

/**
 * An expression representing a JOIN in JPQL terms.
 *
 * @version $Revision: 1.1 $
 */
public class JoinExpression extends ScalarExpression
{
    /** Field name that we are joining to. */
    private String fieldName;

    /** Whether to use a left join (otherwise is inner join). */
    private boolean leftJoin;

    /** Whether it is for fetching. */
    private boolean fetch;
    
    /**
     * Constructor.
     * @param qs The Query Statement
     * @param fieldName "Name" for field being joined to
     * @param leftJoin whether this is a left join, otherwise it is an inner join
     * @param fetch whether to fetch the right hand expression by the query
     **/
    public JoinExpression(QueryExpression qs, String fieldName, boolean leftJoin, boolean fetch)
    {
        super(qs);

        this.fieldName = fieldName;
        this.leftJoin = leftJoin;
        this.fetch = fetch;
    }

    /**
     * Accessor for the field name being joined.
     * @return The field name (including any alias)
     */
    public String getFieldName()
    {
        return fieldName;
    }

    /**
     * @return the leftJoin
     */
    public boolean isLeftJoin()
    {
        return leftJoin;
    }

    /**
     * @return the fetch
     */
    public boolean isFetch()
    {
        return fetch;
    }
}