/*
 * Decompiled with CFR 0.152.
 */
package org.apache.taglibs.standard.extra.spath;

import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Properties;
import java.util.Stack;
import org.apache.taglibs.standard.extra.spath.AttributePredicate;
import org.apache.taglibs.standard.extra.spath.ParseException;
import org.apache.taglibs.standard.extra.spath.Path;
import org.apache.taglibs.standard.extra.spath.Predicate;
import org.apache.taglibs.standard.extra.spath.SPathParser;
import org.apache.taglibs.standard.extra.spath.Step;
import org.apache.xalan.serialize.Serializer;
import org.apache.xalan.serialize.SerializerFactory;
import org.apache.xalan.templates.OutputProperties;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLFilterImpl;
import org.xml.sax.helpers.XMLReaderFactory;

public class SPathFilter
extends XMLFilterImpl {
    protected List steps;
    private int depth;
    private Stack acceptedDepths;
    private int excludedDepth;
    private static final boolean DEBUG = false;

    public static void main(String[] stringArray) throws ParseException, IOException, SAXException {
        System.setProperty("org.xml.sax.driver", "org.apache.xerces.parsers.SAXParser");
        String string = stringArray[0];
        SPathParser sPathParser = new SPathParser(string);
        Path path = sPathParser.expression();
        XMLReader xMLReader = XMLReaderFactory.createXMLReader();
        SPathFilter sPathFilter = new SPathFilter(path);
        XMLFilterImpl xMLFilterImpl = new XMLFilterImpl();
        sPathFilter.setParent(xMLReader);
        xMLFilterImpl.setParent(sPathFilter);
        Serializer serializer = SerializerFactory.getSerializer((Properties)OutputProperties.getDefaultMethodProperties((String)"xml"));
        serializer.setOutputStream((OutputStream)System.out);
        xMLFilterImpl.setContentHandler(serializer.asContentHandler());
        xMLFilterImpl.parse(new InputSource(System.in));
        System.out.println();
    }

    public SPathFilter(Path path) {
        this.init();
        this.steps = path.getSteps();
    }

    private void init() {
        this.depth = 0;
        this.excludedDepth = -1;
        this.acceptedDepths = new Stack();
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        ++this.depth;
        if (this.isAccepted()) {
            this.getContentHandler().startElement(string, string2, string3, attributes);
            return;
        }
        if (this.isExcluded()) {
            return;
        }
        Step step = (Step)this.steps.get(this.acceptedDepths.size());
        if (SPathFilter.nodeMatchesStep(step, string, string2, string3, attributes)) {
            this.acceptedDepths.push(new Integer(this.depth - 1));
            if (this.isAccepted()) {
                this.getContentHandler().startElement(string, string2, string3, attributes);
            }
        } else if (!step.isDepthUnlimited()) {
            this.excludedDepth = this.depth - 1;
        }
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        --this.depth;
        if (this.isExcluded()) {
            if (this.excludedDepth == this.depth) {
                this.excludedDepth = -1;
            }
            return;
        }
        if (this.isAccepted()) {
            this.getContentHandler().endElement(string, string2, string3);
        }
        if (this.acceptedDepths.size() > 0 && (Integer)this.acceptedDepths.peek() == this.depth) {
            this.acceptedDepths.pop();
        }
    }

    @Override
    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        if (this.isAccepted()) {
            this.getContentHandler().ignorableWhitespace(cArray, n, n2);
        }
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (this.isAccepted()) {
            this.getContentHandler().characters(cArray, n, n2);
        }
    }

    @Override
    public void startPrefixMapping(String string, String string2) throws SAXException {
        if (this.isAccepted()) {
            this.getContentHandler().startPrefixMapping(string, string2);
        }
    }

    @Override
    public void endPrefixMapping(String string) throws SAXException {
        if (this.isAccepted()) {
            this.getContentHandler().endPrefixMapping(string);
        }
    }

    @Override
    public void processingInstruction(String string, String string2) throws SAXException {
        if (this.isAccepted()) {
            this.getContentHandler().processingInstruction(string, string2);
        }
    }

    @Override
    public void skippedEntity(String string) throws SAXException {
        if (this.isAccepted()) {
            this.getContentHandler().skippedEntity(string);
        }
    }

    @Override
    public void startDocument() {
        this.init();
    }

    public static boolean nodeMatchesStep(Step step, String string, String string2, String string3, Attributes attributes) {
        if (!step.isMatchingName(string, string2)) {
            return false;
        }
        List list = step.getPredicates();
        for (int i = 0; list != null && i < list.size(); ++i) {
            Predicate predicate = (Predicate)list.get(i);
            if (!(predicate instanceof AttributePredicate)) {
                throw new UnsupportedOperationException("only attribute predicates are supported by filter");
            }
            if (((AttributePredicate)predicate).isMatchingAttribute(attributes)) continue;
            return false;
        }
        return true;
    }

    private boolean isAccepted() {
        return this.acceptedDepths.size() >= this.steps.size();
    }

    private boolean isExcluded() {
        return this.excludedDepth != -1;
    }
}

