/*
 * Decompiled with CFR 0.152.
 */
package org.apache.taglibs.standard.lang.jstl;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.taglibs.standard.lang.jstl.Coercions;
import org.apache.taglibs.standard.lang.jstl.Constants;
import org.apache.taglibs.standard.lang.jstl.ELException;
import org.apache.taglibs.standard.lang.jstl.Expression;
import org.apache.taglibs.standard.lang.jstl.Logger;
import org.apache.taglibs.standard.lang.jstl.VariableResolver;

public class FunctionInvocation
extends Expression {
    private String functionName;
    private List argumentList;

    public String getFunctionName() {
        return this.functionName;
    }

    public void setFunctionName(String string) {
        this.functionName = string;
    }

    public List getArgumentList() {
        return this.argumentList;
    }

    public void setArgumentList(List list) {
        this.argumentList = list;
    }

    public FunctionInvocation(String string, List list) {
        this.functionName = string;
        this.argumentList = list;
    }

    @Override
    public String getExpressionString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.functionName);
        stringBuffer.append("(");
        Iterator iterator = this.argumentList.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(((Expression)iterator.next()).getExpressionString());
            if (!iterator.hasNext()) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    @Override
    public Object evaluate(Object object, VariableResolver variableResolver, Map map, String string, Logger logger) throws ELException {
        Class<?>[] classArray;
        Method method;
        String string2;
        if (map == null) {
            logger.logError(Constants.UNKNOWN_FUNCTION, this.functionName);
        }
        if ((string2 = this.functionName).indexOf(":") == -1) {
            if (string == null) {
                logger.logError(Constants.UNKNOWN_FUNCTION, string2);
            }
            string2 = string + ":" + string2;
        }
        if ((method = (Method)map.get(string2)) == null) {
            logger.logError(Constants.UNKNOWN_FUNCTION, string2);
        }
        if ((classArray = method.getParameterTypes()).length != this.argumentList.size()) {
            logger.logError(Constants.INAPPROPRIATE_FUNCTION_ARG_COUNT, new Integer(classArray.length), (Object)new Integer(this.argumentList.size()));
        }
        Object[] objectArray = new Object[this.argumentList.size()];
        for (int i = 0; i < classArray.length; ++i) {
            objectArray[i] = ((Expression)this.argumentList.get(i)).evaluate(object, variableResolver, map, string, logger);
            objectArray[i] = Coercions.coerce(objectArray[i], classArray[i], logger);
        }
        try {
            return method.invoke(null, objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            logger.logError(Constants.FUNCTION_INVOCATION_ERROR, invocationTargetException.getTargetException(), (Object)string2);
            return null;
        }
        catch (Exception exception) {
            logger.logError(Constants.FUNCTION_INVOCATION_ERROR, exception, (Object)string2);
            return null;
        }
    }
}

