/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.development.agent.runtime;

import com.google.apphosting.api.AppEngineInternal;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

class RuntimeHelper {
    private static final Logger logger = Logger.getLogger(RuntimeHelper.class.getName());
    static final Map<String, AppEngineInternal> internalAnnotationCache = Collections.synchronizedMap(new HashMap());
    private static final boolean appEngineInternalOnClasspath;

    private RuntimeHelper() {
    }

    public static void checkRestricted(boolean violationIsError, String classStr, String callingClassStr, String callingClassCodeSource) {
        if (!appEngineInternalOnClasspath) {
            return;
        }
        if (classStr.startsWith("java.") || classStr.startsWith("javax.")) {
            return;
        }
        try {
            Class<?> cls = Class.forName(classStr);
            AppEngineInternal anno = RuntimeHelper.getAppEngineInternalAnnotation(cls);
            if (anno != null) {
                String errorMsg = String.format("Class %s loaded from %s has a dependency on class %s loaded from %s, which is not part of App Engine's supported API.", callingClassStr, callingClassCodeSource, cls.getName(), cls.getProtectionDomain().getCodeSource());
                if (!anno.message().isEmpty()) {
                    errorMsg = errorMsg + "\n" + anno.message();
                }
                if (violationIsError) {
                    throw new NoClassDefFoundError(errorMsg);
                }
                logger.warning(errorMsg + "\nYou are strongly discouraged " + "from using this class - your app may stop working in production at any moment.");
            }
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
    }

    static AppEngineInternal getAppEngineInternalAnnotation(Class<?> cls) {
        LinkedList<String> namesExamined = new LinkedList<String>();
        String name = cls.getName();
        boolean firstPass = true;
        while (name != null) {
            AppEngineInternal anno;
            if (internalAnnotationCache.containsKey(name)) {
                anno = internalAnnotationCache.get(name);
                RuntimeHelper.updateInternalAnnotationCache(namesExamined, anno);
                return anno;
            }
            try {
                namesExamined.add(name);
                if (!firstPass) {
                    cls = Class.forName(name + ".package-info");
                }
                if ((anno = cls.getAnnotation(AppEngineInternal.class)) != null) {
                    RuntimeHelper.updateInternalAnnotationCache(namesExamined, anno);
                    return anno;
                }
            }
            catch (ClassNotFoundException cnfe) {
                // empty catch block
            }
            name = RuntimeHelper.getOwningPackage(name);
            firstPass = false;
        }
        RuntimeHelper.updateInternalAnnotationCache(namesExamined, null);
        return null;
    }

    static void updateInternalAnnotationCache(List<String> namesToUpdate, AppEngineInternal anno) {
        for (String name : namesToUpdate) {
            internalAnnotationCache.put(name, anno);
        }
    }

    static String getOwningPackage(String resource) {
        int lastDot = resource.lastIndexOf(46);
        if (lastDot == -1) {
            return null;
        }
        return resource.substring(0, lastDot);
    }

    static {
        boolean exists = false;
        try {
            AppEngineInternal.class.getName();
            exists = true;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        appEngineInternalOnClasspath = exists;
    }
}

