/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.server.spi.config;

import com.google.api.server.spi.ServiceContext;
import com.google.api.server.spi.TypeLoader;
import com.google.api.server.spi.config.ApiAuthConfig;
import com.google.api.server.spi.config.ApiCacheControlConfig;
import com.google.api.server.spi.config.ApiClassConfig;
import com.google.api.server.spi.config.ApiFrontendLimitsConfig;
import com.google.api.server.spi.config.ApiNamespaceConfig;
import com.google.api.server.spi.config.ApiSerializationConfig;
import com.google.api.server.spi.config.AuthLevel;
import com.google.api.server.spi.config.ResourceSchema;
import com.google.api.server.spi.config.ResourceSerializer;
import com.google.api.server.spi.config.Serializers;
import com.google.appengine.repackaged.com.google.common.base.Objects;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableList;
import com.google.appengine.repackaged.com.google.common.collect.Iterables;
import com.google.appengine.repackaged.com.google.common.reflect.TypeToken;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ApiConfig {
    private static final List<String> DEFAULT_SCOPES = ImmutableList.of((Object)"https://www.googleapis.com/auth/userinfo.email");
    private static final List<String> DEFAULT_CLIENT_IDS = ImmutableList.of((Object)"292824132082.apps.googleusercontent.com");
    private final TypeLoader typeLoader;
    private String root;
    private String name;
    private String canonicalName;
    private String version;
    private String title;
    private String description;
    private String documentationLink;
    private String backendRoot;
    private boolean isAbstract;
    private boolean defaultVersion;
    private String resource;
    private boolean useDatastore;
    private AuthLevel authLevel;
    private List<String> scopes;
    private List<String> audiences;
    private List<String> clientIds;
    private final ApiAuthConfig authConfig;
    private final ApiCacheControlConfig cacheControlConfig;
    private final ApiFrontendLimitsConfig frontendLimitsConfig;
    private final ApiSerializationConfig serializationConfig;
    private final ApiNamespaceConfig namespaceConfig;
    private final ApiClassConfig apiClassConfig;

    protected ApiConfig(ServiceContext serviceContext, TypeLoader typeLoader, Class<?> apiClass) {
        this.typeLoader = typeLoader;
        this.authConfig = this.createAuthConfig();
        this.cacheControlConfig = this.createCacheControlConfig();
        this.frontendLimitsConfig = this.createFrontendLimitsConfig();
        this.serializationConfig = this.createSerializationConfig();
        this.namespaceConfig = this.createNamespaceConfig();
        this.apiClassConfig = this.createApiClassConfig(typeLoader, apiClass);
        this.setDefaults(serviceContext);
    }

    protected ApiConfig(ApiConfig original) {
        this.typeLoader = original.typeLoader;
        this.root = original.root;
        this.name = original.name;
        this.version = original.version;
        this.description = original.description;
        this.backendRoot = original.backendRoot;
        this.isAbstract = original.isAbstract;
        this.defaultVersion = original.defaultVersion;
        this.useDatastore = original.useDatastore;
        this.resource = original.resource;
        this.authLevel = original.authLevel;
        this.scopes = new ArrayList<String>(original.scopes);
        this.audiences = new ArrayList<String>(original.audiences);
        this.clientIds = new ArrayList<String>(original.clientIds);
        this.authConfig = new ApiAuthConfig(original.authConfig);
        this.cacheControlConfig = new ApiCacheControlConfig(original.cacheControlConfig);
        this.frontendLimitsConfig = new ApiFrontendLimitsConfig(original.frontendLimitsConfig);
        this.serializationConfig = new ApiSerializationConfig(original.serializationConfig);
        this.namespaceConfig = new ApiNamespaceConfig(original.namespaceConfig);
        this.apiClassConfig = new ApiClassConfig(original.apiClassConfig, this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof ApiConfig) {
            ApiConfig config = (ApiConfig)o;
            return this.isConfigIdentical(config) && this.apiClassConfig.equals(config.apiClassConfig);
        }
        return false;
    }

    public boolean isConfigIdentical(ApiConfig config) {
        if (config == null) {
            return false;
        }
        return Objects.equal((Object)this.typeLoader, (Object)config.typeLoader) && Objects.equal((Object)this.root, (Object)config.root) && Objects.equal((Object)this.name, (Object)config.name) && Objects.equal((Object)this.canonicalName, (Object)config.canonicalName) && Objects.equal((Object)this.version, (Object)config.version) && Objects.equal((Object)this.title, (Object)config.title) && Objects.equal((Object)this.description, (Object)config.description) && Objects.equal((Object)this.documentationLink, (Object)config.documentationLink) && Objects.equal((Object)this.backendRoot, (Object)config.backendRoot) && this.isAbstract == config.isAbstract && this.defaultVersion == config.defaultVersion && this.useDatastore == config.useDatastore && Objects.equal((Object)this.resource, (Object)config.resource) && Objects.equal((Object)((Object)this.authLevel), (Object)((Object)config.authLevel)) && Objects.equal(this.scopes, config.scopes) && Objects.equal(this.audiences, config.audiences) && Objects.equal(this.clientIds, config.clientIds) && this.authConfig.equals(config.authConfig) && this.cacheControlConfig.equals(config.cacheControlConfig) && this.frontendLimitsConfig.equals(config.frontendLimitsConfig) && this.serializationConfig.equals(config.serializationConfig) && this.namespaceConfig.equals(config.namespaceConfig);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.typeLoader, this.root, this.name, this.canonicalName, this.version, this.title, this.description, this.documentationLink, this.backendRoot, this.isAbstract, this.defaultVersion, this.useDatastore, this.resource, this.authLevel, this.scopes, this.audiences, this.clientIds, this.authConfig, this.cacheControlConfig, this.frontendLimitsConfig, this.serializationConfig, this.apiClassConfig});
    }

    protected ApiAuthConfig createAuthConfig() {
        return new ApiAuthConfig();
    }

    protected ApiCacheControlConfig createCacheControlConfig() {
        return new ApiCacheControlConfig();
    }

    protected ApiFrontendLimitsConfig createFrontendLimitsConfig() {
        return new ApiFrontendLimitsConfig();
    }

    protected ApiSerializationConfig createSerializationConfig() {
        return new ApiSerializationConfig();
    }

    protected ApiNamespaceConfig createNamespaceConfig() {
        return new ApiNamespaceConfig();
    }

    protected ApiClassConfig createApiClassConfig(TypeLoader typeLoader, Class<?> apiClass) {
        return new ApiClassConfig(this, typeLoader, apiClass);
    }

    protected void setDefaults(ServiceContext serviceContext) {
        this.root = "https://" + serviceContext.getAppHostName() + "/_ah/api";
        this.name = serviceContext.getDefaultApiName();
        this.canonicalName = null;
        this.version = "v1";
        this.description = null;
        this.backendRoot = "https://" + serviceContext.getAppHostName() + "/_ah/spi";
        this.isAbstract = false;
        this.defaultVersion = false;
        this.useDatastore = false;
        this.resource = null;
        this.authLevel = AuthLevel.NONE;
        this.scopes = DEFAULT_SCOPES;
        this.audiences = Collections.emptyList();
        this.clientIds = DEFAULT_CLIENT_IDS;
    }

    public void setRoot(String root) {
        this.root = root;
    }

    public String getRoot() {
        return this.root;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setCanonicalName(String canonicalName) {
        this.canonicalName = canonicalName;
    }

    public String getCanonicalName() {
        return this.canonicalName;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getVersion() {
        return this.version;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDocumentationLink(String documentationLink) {
        this.documentationLink = documentationLink;
    }

    public String getDocumentationLink() {
        return this.documentationLink;
    }

    public void setBackendRoot(String backendRoot) {
        this.backendRoot = this.toHttps(backendRoot);
    }

    public String getBackendRoot() {
        return this.backendRoot;
    }

    public void setIsAbstract(boolean isAbstract) {
        this.isAbstract = isAbstract;
    }

    public boolean getIsAbstract() {
        return this.isAbstract;
    }

    public void setIsDefaultVersion(boolean defaultVersion) {
        this.defaultVersion = defaultVersion;
    }

    public boolean getIsDefaultVersion() {
        return this.defaultVersion;
    }

    public void setUseDatastore(boolean useDatastore) {
        this.useDatastore = useDatastore;
    }

    public boolean getUseDatastore() {
        return this.useDatastore;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }

    public String getResource() {
        return this.resource;
    }

    public ApiAuthConfig getAuthConfig() {
        return this.authConfig;
    }

    public ApiCacheControlConfig getCacheControlConfig() {
        return this.cacheControlConfig;
    }

    public ApiFrontendLimitsConfig getFrontendLimitsConfig() {
        return this.frontendLimitsConfig;
    }

    public ApiSerializationConfig getSerializationConfig() {
        return this.serializationConfig;
    }

    public ApiNamespaceConfig getNamespaceConfig() {
        return this.namespaceConfig;
    }

    public void setAuthLevel(AuthLevel authLevel) {
        this.authLevel = authLevel;
    }

    public AuthLevel getAuthLevel() {
        return this.authLevel;
    }

    public void setScopes(List<String> scopes) {
        this.scopes = scopes;
    }

    public List<String> getScopes() {
        return this.scopes;
    }

    public void setAudiences(List<String> audiences) {
        this.audiences = audiences;
    }

    public List<String> getAudiences() {
        return this.audiences;
    }

    public void setClientIds(List<String> clientIds) {
        this.clientIds = clientIds;
    }

    public List<String> getClientIds() {
        return this.clientIds;
    }

    private String toHttps(String url) {
        if (url != null && url.startsWith("http:")) {
            return "https:" + url.substring(5);
        }
        return url;
    }

    public ApiClassConfig getApiClassConfig() {
        return this.apiClassConfig;
    }

    public String getSimpleName(Type type) {
        ResourceSerializer resourceSerializer;
        ResourceSchema resourceSchema;
        Type itemType = TypeLoader.getArrayItemType(type);
        if (type == null) {
            return null;
        }
        if (itemType != null) {
            return this.getSimpleName(itemType) + "Collection";
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType p = (ParameterizedType)type;
            StringBuilder builder = new StringBuilder();
            builder.append(this.getSimpleName(p.getRawType()));
            for (Type typeArg : p.getActualTypeArguments()) {
                builder.append('_');
                builder.append(this.getSimpleName(typeArg));
            }
            return builder.toString();
        }
        Class serializerClass = (Class)Iterables.getOnlyElement(Serializers.getSerializerClasses(type, this.getSerializationConfig()), null);
        if (serializerClass != null && ResourceSerializer.class.isAssignableFrom(serializerClass) && (resourceSchema = (resourceSerializer = (ResourceSerializer)Serializers.instantiate(serializerClass, type)).getResourceSchema()) != null && resourceSchema.getName() != null) {
            return resourceSchema.getName();
        }
        return TypeToken.of(type).getRawType().getSimpleName();
    }

    public static class Factory {
        public ApiConfig create(ServiceContext serviceContext, TypeLoader typeLoader, Class<?> endpointClass) {
            return new ApiConfig(serviceContext, typeLoader, endpointClass);
        }

        public ApiConfig copy(ApiConfig old) {
            return new ApiConfig(old);
        }
    }
}

