/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.server.spi.config;

import com.google.api.server.spi.config.ApiConfig;
import com.google.appengine.repackaged.com.google.common.base.Function;
import com.google.appengine.repackaged.com.google.common.base.Objects;
import com.google.appengine.repackaged.com.google.common.collect.Iterables;

public class ConfigClassPair {
    private final ApiConfig config;
    private final Class<?> endpointClass;

    public ConfigClassPair(ApiConfig config, Class<?> endpointClass) {
        this.config = config;
        this.endpointClass = endpointClass;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof ConfigClassPair) {
            ConfigClassPair pair = (ConfigClassPair)other;
            return Objects.equal((Object)this.config, (Object)pair.config) && Objects.equal(this.endpointClass, pair.endpointClass);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.config, this.endpointClass});
    }

    public ApiConfig getConfig() {
        return this.config;
    }

    public Class<?> getEndpointClass() {
        return this.endpointClass;
    }

    public static Iterable<ApiConfig> getConfigIterable(Iterable<ConfigClassPair> pair) {
        Function<ConfigClassPair, ApiConfig> f = new Function<ConfigClassPair, ApiConfig>(){

            public ApiConfig apply(ConfigClassPair pair) {
                return pair.getConfig();
            }
        };
        return Iterables.transform(pair, (Function)f);
    }
}

