/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.server.spi.config.annotationreader;

import com.google.api.server.spi.config.AnnotationBoolean;
import com.google.api.server.spi.config.ApiConfig;
import com.google.api.server.spi.config.ApiSerializationConfig;
import com.google.api.server.spi.config.ApiSerializationProperty;
import com.google.api.server.spi.config.ApiSerializer;
import com.google.api.server.spi.config.ResourcePropertySchema;
import com.google.api.server.spi.config.ResourceSerializer;
import com.google.api.server.spi.config.Serializer;
import com.google.api.server.spi.config.Serializers;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableMap;
import com.google.appengine.repackaged.com.google.common.reflect.TypeToken;
import com.google.appengine.repackaged.org.codehaus.jackson.JsonGenerator;
import com.google.appengine.repackaged.org.codehaus.jackson.JsonParser;
import com.google.appengine.repackaged.org.codehaus.jackson.JsonProcessingException;
import com.google.appengine.repackaged.org.codehaus.jackson.JsonToken;
import com.google.appengine.repackaged.org.codehaus.jackson.map.DeserializationContext;
import com.google.appengine.repackaged.org.codehaus.jackson.map.JsonDeserializer;
import com.google.appengine.repackaged.org.codehaus.jackson.map.JsonSerializer;
import com.google.appengine.repackaged.org.codehaus.jackson.map.SerializerProvider;
import com.google.appengine.repackaged.org.codehaus.jackson.map.introspect.Annotated;
import com.google.appengine.repackaged.org.codehaus.jackson.map.introspect.AnnotatedClass;
import com.google.appengine.repackaged.org.codehaus.jackson.map.introspect.AnnotatedField;
import com.google.appengine.repackaged.org.codehaus.jackson.map.introspect.AnnotatedMember;
import com.google.appengine.repackaged.org.codehaus.jackson.map.introspect.AnnotatedMethod;
import com.google.appengine.repackaged.org.codehaus.jackson.map.introspect.NopAnnotationIntrospector;
import com.google.appengine.repackaged.org.codehaus.jackson.type.TypeReference;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public class ApiAnnotationIntrospector
extends NopAnnotationIntrospector {
    private final ApiSerializationConfig config;

    public ApiAnnotationIntrospector() {
        this(new ApiSerializationConfig());
    }

    public ApiAnnotationIntrospector(ApiSerializationConfig config) {
        this.config = config;
    }

    @Override
    public boolean isHandled(Annotation ann) {
        return ann instanceof ApiSerializationProperty || ann instanceof ApiSerializer;
    }

    @Override
    public boolean hasIgnoreMarker(AnnotatedMember member) {
        ApiSerializationProperty apiProperty = member.getAnnotation(ApiSerializationProperty.class);
        if (apiProperty != null) {
            return apiProperty.ignored() == AnnotationBoolean.TRUE;
        }
        return false;
    }

    @Override
    public boolean isIgnorableMethod(AnnotatedMethod method) {
        ApiSerializationProperty apiProperty = method.getAnnotation(ApiSerializationProperty.class);
        if (apiProperty != null) {
            return apiProperty.ignored() == AnnotationBoolean.TRUE;
        }
        return false;
    }

    @Override
    public String findGettablePropertyName(AnnotatedMethod method) {
        ApiSerializationProperty apiName = method.getAnnotation(ApiSerializationProperty.class);
        if (apiName != null && apiName.ignored() != AnnotationBoolean.TRUE) {
            return apiName.name();
        }
        return null;
    }

    @Override
    public String findSettablePropertyName(AnnotatedMethod method) {
        ApiSerializationProperty apiName = method.getAnnotation(ApiSerializationProperty.class);
        if (apiName != null && apiName.ignored() != AnnotationBoolean.TRUE) {
            return apiName.name();
        }
        return null;
    }

    @Override
    public JsonSerializer<?> findSerializer(Annotated method) {
        return ApiAnnotationIntrospector.getJsonSerializer(this.findSerializerInstance(method));
    }

    @Override
    public String findEnumValue(Enum<?> value) {
        return value.name();
    }

    @Nullable
    private static <TFrom, TTo> JsonSerializer<TFrom> getJsonSerializer(final @Nullable Serializer<TFrom, TTo> serializer) {
        if (serializer == null) {
            return null;
        }
        return new JsonSerializer<TFrom>(){

            @Override
            public void serialize(TFrom value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
                jgen.writeObject(serializer.serialize(value));
            }
        };
    }

    @Override
    public JsonDeserializer<?> findDeserializer(Annotated a) {
        return ApiAnnotationIntrospector.getJsonDeserializer(this.findSerializerInstance(a));
    }

    @Override
    public String findSerializablePropertyName(AnnotatedField af) {
        ApiSerializationProperty apiName = af.getAnnotation(ApiSerializationProperty.class);
        if (apiName != null) {
            if (apiName.ignored() != AnnotationBoolean.TRUE) {
                return apiName.name();
            }
        } else if (af.isPublic()) {
            return "";
        }
        return null;
    }

    @Override
    public String findDeserializablePropertyName(AnnotatedField af) {
        ApiSerializationProperty apiName = af.getAnnotation(ApiSerializationProperty.class);
        if (apiName != null) {
            if (apiName.ignored() != AnnotationBoolean.TRUE) {
                return apiName.name();
            }
        } else if (af.isPublic()) {
            return "";
        }
        return null;
    }

    private static <TFrom, TTo> JsonDeserializer<TFrom> getJsonDeserializer(final @Nullable Serializer<TFrom, TTo> serializer) {
        if (serializer == null) {
            return null;
        }
        final TypeReference<TTo> serializedType = ApiAnnotationIntrospector.typeReferenceOf(serializer);
        if (serializer instanceof ResourceSerializer) {
            ResourceSerializer resourceSerializer = (ResourceSerializer)serializer;
            return new ResourceDeserializer(resourceSerializer);
        }
        return new JsonDeserializer<TFrom>(){

            @Override
            public TFrom deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
                Object deserialized = jp.readValueAs(serializedType);
                return serializer.deserialize(deserialized);
            }
        };
    }

    public static Type getSchemaType(Type type, ApiConfig config) {
        List<Class<Serializer<?, ?>>> serializers;
        if (type instanceof Class && !(serializers = Serializers.getSerializerClasses(type, config.getSerializationConfig())).isEmpty() && !ResourceSerializer.class.isAssignableFrom(serializers.get(0))) {
            Type sourceType = Serializers.getSourceType(serializers.get(0));
            Type serializedType = Serializers.getTargetType(serializers.get(0));
            Preconditions.checkArgument((boolean)TypeToken.of(sourceType).isAssignableFrom(type), (String)"Serializer specified for %s, but only serializes for %s: %s", (Object[])new Object[]{type, sourceType, serializers.get(0)});
            Preconditions.checkArgument((serializedType != null ? 1 : 0) != 0, (String)"Couldn't find Serializer interface in serializer for %s: %s", (Object[])new Object[]{type, serializers.get(0)});
            return serializedType;
        }
        return type;
    }

    @Nullable
    private Serializer<?, ?> findSerializerInstance(Annotated a) {
        AnnotatedClass clazz;
        List<Class<Serializer<?, ?>>> serializerClasses;
        if (a instanceof AnnotatedClass && !(serializerClasses = Serializers.getSerializerClasses((clazz = (AnnotatedClass)a).getRawType(), this.config)).isEmpty()) {
            return Serializers.instantiate(serializerClasses.get(0), a.getGenericType());
        }
        return null;
    }

    private static <T> TypeReference<T> typeReferenceOf(Serializer<?, T> serializer) {
        Class<?> serializerClass = serializer.getClass();
        final Type type = Serializers.getTargetType(serializerClass);
        return new TypeReference<T>(){

            @Override
            public Type getType() {
                return type;
            }
        };
    }

    private static class ResourceDeserializer<TFrom>
    extends JsonDeserializer<TFrom> {
        private ResourceSerializer<TFrom> resourceSerializer;

        private ResourceDeserializer(ResourceSerializer<TFrom> resourceSerializer) {
            this.resourceSerializer = resourceSerializer;
        }

        @Override
        public TFrom deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            Map<String, ResourcePropertySchema> properties = this.resourceSerializer.getResourceSchema().getProperties();
            ImmutableMap.Builder values = ImmutableMap.builder();
            while (jp.nextValue() != JsonToken.END_OBJECT) {
                String property = jp.getCurrentName();
                final ResourcePropertySchema schemaType = properties.get(property);
                if (schemaType == null) continue;
                TypeReference<Object> jacksonTypeRef = new TypeReference<Object>(){

                    @Override
                    public Type getType() {
                        return schemaType.getJavaType();
                    }
                };
                values.put((Object)property, jp.readValueAs(jacksonTypeRef));
            }
            return this.resourceSerializer.deserialize(values.build());
        }
    }
}

