/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.server.spi.config.datastore;

import com.google.api.server.spi.ServiceContext;
import com.google.api.server.spi.config.ApiClassConfig;
import com.google.api.server.spi.config.ApiConfig;
import com.google.api.server.spi.config.ApiConfigException;
import com.google.api.server.spi.config.ApiConfigSource;
import com.google.appengine.api.datastore.DatastoreService;
import com.google.appengine.api.datastore.DatastoreServiceFactory;
import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.EntityNotFoundException;
import com.google.appengine.api.datastore.Key;
import com.google.appengine.api.datastore.KeyFactory;
import com.google.appengine.api.memcache.AsyncMemcacheService;
import com.google.appengine.api.memcache.MemcacheService;
import com.google.appengine.api.memcache.MemcacheServiceFactory;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class ApiConfigDatastoreReader
implements ApiConfigSource {
    private static final Logger logger = Logger.getLogger(ApiConfigDatastoreReader.class.getName());
    private final DatastoreService datastoreService;
    private final AsyncMemcacheService memcacheService;
    public static final String ENDPOINT_CONFIGURATION_KIND = "GoogleCloudEndpointConfiguration";
    public static final String METHOD_CONFIGURATION_KIND = "GoogleCloudEndpointMethodConfiguration";
    private Future<Boolean> memcacheWriteResult;
    private boolean lastValueReadFromMemcache;

    public ApiConfigDatastoreReader(DatastoreService datastoreService, AsyncMemcacheService memcacheService) {
        this.datastoreService = datastoreService;
        this.memcacheService = memcacheService;
        this.memcacheWriteResult = null;
        this.lastValueReadFromMemcache = false;
    }

    public ApiConfigDatastoreReader() {
        this(DatastoreServiceFactory.getDatastoreService(), MemcacheServiceFactory.getAsyncMemcacheService());
    }

    @Override
    public void loadEndpointClass(ServiceContext serviceContext, Class<?> endpointClass, ApiConfig config) throws ApiConfigException {
        Entity endpointEntity;
        ApiClassConfig classConfig = config.getApiClassConfig();
        Entity entity = endpointEntity = classConfig.getUseDatastore() ? this.getEndpointEntityOrNull(endpointClass) : null;
        if (endpointEntity != null) {
            this.processEndpointEntity(endpointEntity, classConfig);
        }
    }

    private Entity getEndpointEntityOrNull(Class<?> endpointClass) {
        Entity entity = this.getMemcacheEntityOrNull(endpointClass);
        if (entity != null) {
            this.lastValueReadFromMemcache = true;
            return entity;
        }
        this.lastValueReadFromMemcache = false;
        entity = this.getDatastoreEntityOrNull(endpointClass);
        if (entity == null) {
            return null;
        }
        this.memcacheWriteResult = this.memcacheService.put(this.getEndpointMemcacheKey(endpointClass.getName()), (Object)entity, null, MemcacheService.SetPolicy.ADD_ONLY_IF_NOT_PRESENT);
        return entity;
    }

    private Entity getMemcacheEntityOrNull(Class<?> endpointClass) {
        try {
            Object memcacheValue = this.memcacheService.get(this.getEndpointMemcacheKey(endpointClass.getName())).get();
            if (memcacheValue == null || !(memcacheValue instanceof Entity)) {
                memcacheValue = this.memcacheService.get(this.getEndpointMemcacheKey(endpointClass.getSimpleName())).get();
            }
            return (Entity)memcacheValue;
        }
        catch (InterruptedException e) {
            logger.log(Level.WARNING, "Error while retrieving memcached endpoint configuration.", e);
            return null;
        }
        catch (ExecutionException e) {
            logger.log(Level.WARNING, "Error while retrieving memcached endpoint configuration.", e);
            return null;
        }
    }

    private Entity getDatastoreEntityOrNull(Class<?> endpointClass) {
        try {
            return this.datastoreService.get(this.getEndpointDatastoreKey(endpointClass.getName()));
        }
        catch (EntityNotFoundException e) {
            try {
                return this.datastoreService.get(this.getEndpointDatastoreKey(endpointClass.getSimpleName()));
            }
            catch (EntityNotFoundException ex) {
                return null;
            }
        }
    }

    private void processEndpointEntity(Entity endpointEntity, ApiClassConfig config) throws ApiConfigException {
        List<String> clientIds;
        List<String> audiences;
        List<String> scopes = this.processStringListProperty(endpointEntity, "scopes");
        if (scopes != null) {
            config.setScopes(scopes);
        }
        if ((audiences = this.processStringListProperty(endpointEntity, "audiences")) != null) {
            config.setAudiences(audiences);
        }
        if ((clientIds = this.processStringListProperty(endpointEntity, "clientIds")) != null) {
            config.setClientIds(clientIds);
        }
    }

    private List<String> processStringListProperty(Entity endpointEntity, String propertyName) throws ApiConfigException {
        List<String> propertyList;
        if (!endpointEntity.hasProperty(propertyName)) {
            return null;
        }
        Object property = endpointEntity.getProperty(propertyName);
        if (property instanceof String) {
            return Collections.singletonList((String)property);
        }
        if (property instanceof List && (propertyList = ApiConfigDatastoreReader.safeCast((List)property)) != null) {
            return propertyList;
        }
        throw new ApiConfigException(endpointEntity + "." + propertyName + " was not of type String or List<String>.");
    }

    private static List<String> safeCast(List<?> list) {
        for (String string : list) {
            if (string instanceof String) continue;
            return null;
        }
        return list;
    }

    @Override
    public void loadEndpointMethods(ServiceContext serviceContext, Class<?> endpointClass, ApiClassConfig.MethodConfigMap methodConfigMap) {
    }

    @Override
    public boolean isStaticConfig(ApiConfig config) {
        return !config.getApiClassConfig().getUseDatastore();
    }

    private Key getEndpointDatastoreKey(String endpointClassName) {
        return KeyFactory.createKey((String)ENDPOINT_CONFIGURATION_KIND, (String)endpointClassName);
    }

    private Object getEndpointMemcacheKey(String endpointClassName) {
        return "GoogleCloudEndpointConfiguration." + endpointClassName;
    }

    boolean getMemcacheWriteResult() throws Exception {
        if (this.memcacheWriteResult == null) {
            return false;
        }
        return this.memcacheWriteResult.get();
    }

    boolean isLastValueReadFromMemcache() {
        return this.lastValueReadFromMemcache;
    }
}

