/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.server.spi.config.jsonwriter;

import com.google.api.server.spi.config.ApiConfig;
import com.google.api.server.spi.config.ApiSerializer;
import com.google.api.server.spi.config.ResourceSchema;
import com.google.api.server.spi.config.ResourceSerializer;
import com.google.api.server.spi.config.Serializer;
import com.google.api.server.spi.config.Serializers;
import com.google.api.server.spi.config.jsonwriter.ResourceSchemaProvider;
import java.util.List;
import javax.annotation.Nullable;

abstract class AbstractResourceSchemaProvider
implements ResourceSchemaProvider {
    AbstractResourceSchemaProvider() {
    }

    @Override
    @Nullable
    public ResourceSchema getResourceSchema(Class<?> clazz, ApiConfig config) {
        return this.getResourceSchemaImpl(clazz, config);
    }

    @Nullable
    private <T> ResourceSchema getResourceSchemaImpl(Class<T> clazz, ApiConfig config) {
        ApiSerializer apiSerialization = clazz.getAnnotation(ApiSerializer.class);
        List<Class<Serializer<?, ?>>> serializerClasses = Serializers.getSerializerClasses(clazz, config.getSerializationConfig());
        if (!serializerClasses.isEmpty() && ResourceSerializer.class.isAssignableFrom(serializerClasses.get(0))) {
            ResourceSerializer resourceSerializer = (ResourceSerializer)Serializers.instantiate(serializerClasses.get(0), clazz);
            return resourceSerializer.getResourceSchema();
        }
        return null;
    }
}

