/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.server.spi.config.validation;

import com.google.api.server.spi.TypeLoader;
import com.google.api.server.spi.config.ApiClassConfig;
import com.google.api.server.spi.config.ApiConfig;
import com.google.api.server.spi.config.ApiMethodConfig;
import com.google.api.server.spi.config.ApiNamespaceConfig;
import com.google.api.server.spi.config.ApiParameterConfig;
import com.google.api.server.spi.config.Serializer;
import com.google.api.server.spi.config.Serializers;
import com.google.api.server.spi.config.validation.ApiClassConfigInvalidException;
import com.google.api.server.spi.config.validation.ApiConfigInvalidException;
import com.google.api.server.spi.config.validation.ApiMethodConfigInvalidException;
import com.google.api.server.spi.config.validation.ApiParameterConfigInvalidException;
import com.google.api.server.spi.config.validation.CollectionResourceException;
import com.google.api.server.spi.config.validation.DuplicateParameterNameException;
import com.google.api.server.spi.config.validation.DuplicateRestPathException;
import com.google.api.server.spi.config.validation.GenericTypeException;
import com.google.api.server.spi.config.validation.InconsistentApiConfigurationException;
import com.google.api.server.spi.config.validation.InvalidMethodNameException;
import com.google.api.server.spi.config.validation.InvalidNamespaceException;
import com.google.api.server.spi.config.validation.InvalidParameterAnnotationsException;
import com.google.api.server.spi.config.validation.MissingParameterNameException;
import com.google.api.server.spi.config.validation.MultipleSerializersException;
import com.google.api.server.spi.config.validation.NamedResourceException;
import com.google.api.server.spi.config.validation.NestedCollectionException;
import com.google.api.server.spi.config.validation.NoSerializerInterfaceException;
import com.google.api.server.spi.config.validation.OverloadedMethodException;
import com.google.api.server.spi.config.validation.WrongSerializerTypeException;
import com.google.appengine.repackaged.com.google.common.collect.Iterables;
import com.google.appengine.repackaged.com.google.common.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class ApiConfigValidator {
    public void validate(Iterable<ApiConfig> apiConfigs) throws ApiConfigInvalidException, ApiClassConfigInvalidException, ApiMethodConfigInvalidException, ApiParameterConfigInvalidException {
        if (Iterables.isEmpty(apiConfigs)) {
            return;
        }
        Iterator<ApiConfig> i = apiConfigs.iterator();
        ApiConfig first = i.next();
        this.validate(first);
        while (i.hasNext()) {
            ApiConfig config = i.next();
            if (!config.isConfigIdentical(first)) {
                throw new InconsistentApiConfigurationException(config, first);
            }
            this.validate(config);
        }
    }

    public void validate(ApiConfig config) throws ApiClassConfigInvalidException, ApiMethodConfigInvalidException, ApiParameterConfigInvalidException {
        this.validateNamespaceConfig(config.getNamespaceConfig(), config.getApiClassConfig());
        this.validateMethods(config.getApiClassConfig().getMethods());
    }

    private void validateNamespaceConfig(ApiNamespaceConfig config, ApiClassConfig apiConfig) throws ApiClassConfigInvalidException {
        if (!(config.getOwnerDomain().isEmpty() && config.getOwnerName().isEmpty() && config.getPackagePath().isEmpty() || !config.getOwnerDomain().isEmpty() && !config.getOwnerName().isEmpty())) {
            throw new InvalidNamespaceException(apiConfig);
        }
    }

    private void validateMethods(ApiClassConfig.MethodConfigMap configMap) throws ApiClassConfigInvalidException, ApiMethodConfigInvalidException, ApiParameterConfigInvalidException {
        HashMap<String, ApiMethodConfig> restfulSignatures = new HashMap<String, ApiMethodConfig>(configMap.size());
        HashMap<String, ApiMethodConfig> javaMethodNames = new HashMap<String, ApiMethodConfig>(configMap.size());
        for (ApiMethodConfig methodConfig : configMap.values()) {
            String restSignature = methodConfig.getRestfulSignature();
            ApiMethodConfig seenMethod = (ApiMethodConfig)restfulSignatures.get(restSignature);
            if (seenMethod != null) {
                throw new DuplicateRestPathException(configMap.getApiClassConfig(), restSignature, methodConfig.getName(), seenMethod.getName());
            }
            restfulSignatures.put(restSignature, methodConfig);
            String javaName = methodConfig.getFullJavaName();
            seenMethod = (ApiMethodConfig)javaMethodNames.get(javaName);
            if (seenMethod != null) {
                throw new OverloadedMethodException(configMap.getApiClassConfig(), javaName, methodConfig.getName(), seenMethod.getName());
            }
            javaMethodNames.put(javaName, methodConfig);
            this.validateMethod(methodConfig);
        }
    }

    private void validateMethod(ApiMethodConfig config) throws ApiMethodConfigInvalidException, ApiParameterConfigInvalidException {
        if (config.getFullMethodName().length() == 0) {
            throw new InvalidMethodNameException(config, config.getName());
        }
        HashSet<String> parameterNames = new HashSet<String>();
        for (ApiParameterConfig p : config.getParameterConfigs()) {
            this.validateParameter(p, parameterNames, config.getPathParameters());
        }
    }

    private void validateParameter(ApiParameterConfig parameter, Set<String> parameterNames, Collection<String> pathParameters) throws ApiParameterConfigInvalidException {
        Type type;
        try {
            this.validateParameterSerializers(parameter, parameter.getSerializers(), parameter.getType());
            this.validateParameterSerializers(parameter, parameter.getRepeatedItemSerializers(), parameter.getRepeatedItemType());
        }
        catch (IllegalStateException e) {
            throw new ApiParameterConfigInvalidException(parameter, e.getMessage());
        }
        if (parameter.isRepeated()) {
            type = parameter.getRepeatedItemSerializedType();
            if (TypeLoader.isArrayType(type)) {
                throw new NestedCollectionException(parameter, type);
            }
        } else {
            type = parameter.getSchemaBaseType();
        }
        ApiParameterConfig.Classification classification = parameter.getClassification();
        switch (classification) {
            case INJECTED: {
                break;
            }
            case API_PARAMETER: {
                this.validateApiParameter(parameter, parameterNames, pathParameters, type);
                break;
            }
            case RESOURCE: {
                this.validateResourceParameter(parameter, type);
                break;
            }
            case UNKNOWN: {
                throw new GenericTypeException(parameter);
            }
        }
    }

    private void validateParameterSerializers(ApiParameterConfig config, List<Class<? extends Serializer<?, ?>>> serializers, Type parameterType) throws ApiParameterConfigInvalidException {
        if (serializers.isEmpty()) {
            return;
        }
        if (serializers.size() > 1) {
            throw new MultipleSerializersException(config, serializers);
        }
        Type sourceType = Serializers.getSourceType(serializers.get(0));
        Type serializedType = Serializers.getTargetType(serializers.get(0));
        if (sourceType == null || serializedType == null) {
            throw new NoSerializerInterfaceException(config, serializers.get(0));
        }
        if (!TypeToken.of(sourceType).isAssignableFrom(parameterType)) {
            throw new WrongSerializerTypeException(config, serializers.get(0), parameterType, sourceType);
        }
    }

    private void validateApiParameter(ApiParameterConfig parameter, Set<String> parameterNames, Collection<String> pathParameters, Type type) throws ApiParameterConfigInvalidException {
        if (parameter.getName() == null) {
            throw new MissingParameterNameException(parameter, type);
        }
        if (parameterNames.contains(parameter.getName())) {
            throw new DuplicateParameterNameException(parameter);
        }
        parameterNames.add(parameter.getName());
        if ((parameter.getNullable() || parameter.getDefaultValue() != null) && pathParameters.contains(parameter.getName())) {
            throw new InvalidParameterAnnotationsException(parameter);
        }
    }

    private void validateResourceParameter(ApiParameterConfig parameter, Type type) throws ApiParameterConfigInvalidException {
        if (parameter.isRepeated()) {
            throw new CollectionResourceException(parameter, parameter.getRepeatedItemSerializedType(), parameter.getSchemaBaseType());
        }
        if (parameter.getName() != null) {
            throw new NamedResourceException(parameter, type);
        }
    }
}

