/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.api.client.http.javanet;

import com.google.appengine.repackaged.com.google.api.client.http.LowLevelHttpResponse;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

final class NetHttpResponse
extends LowLevelHttpResponse {
    private final HttpURLConnection connection;
    private final int responseCode;
    private final String responseMessage;
    private final ArrayList<String> headerNames = new ArrayList();
    private final ArrayList<String> headerValues = new ArrayList();

    NetHttpResponse(HttpURLConnection connection) throws IOException {
        this.connection = connection;
        int responseCode = connection.getResponseCode();
        this.responseCode = responseCode == -1 ? 0 : responseCode;
        this.responseMessage = connection.getResponseMessage();
        ArrayList<String> headerNames = this.headerNames;
        ArrayList<String> headerValues = this.headerValues;
        for (Map.Entry<String, List<String>> entry : connection.getHeaderFields().entrySet()) {
            String key = entry.getKey();
            if (key == null) continue;
            for (String value : entry.getValue()) {
                if (value == null) continue;
                headerNames.add(key);
                headerValues.add(value);
            }
        }
    }

    @Override
    public int getStatusCode() {
        return this.responseCode;
    }

    @Override
    public InputStream getContent() throws IOException {
        try {
            return this.connection.getInputStream();
        }
        catch (IOException ioe) {
            return this.connection.getErrorStream();
        }
    }

    @Override
    public String getContentEncoding() {
        return this.connection.getContentEncoding();
    }

    @Override
    public long getContentLength() {
        String string = this.connection.getHeaderField("Content-Length");
        return string == null ? -1L : Long.parseLong(string);
    }

    @Override
    public String getContentType() {
        return this.connection.getHeaderField("Content-Type");
    }

    @Override
    public String getReasonPhrase() {
        return this.responseMessage;
    }

    @Override
    public String getStatusLine() {
        String result = this.connection.getHeaderField(0);
        return result != null && result.startsWith("HTTP/1.") ? result : null;
    }

    @Override
    public int getHeaderCount() {
        return this.headerNames.size();
    }

    @Override
    public String getHeaderName(int index) {
        return this.headerNames.get(index);
    }

    @Override
    public String getHeaderValue(int index) {
        return this.headerValues.get(index);
    }

    @Override
    public void disconnect() {
        this.connection.disconnect();
    }
}

