/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.logging;

import com.google.appengine.repackaged.com.google.common.util.CallerFinder;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import java.util.IllegalFormatException;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public final class FormattingLogger {
    private final Logger logger;

    public static FormattingLogger getLogger(String name) {
        return new FormattingLogger(Logger.getLogger(name));
    }

    public static FormattingLogger getLogger(Class<?> cls) {
        return FormattingLogger.getLogger(cls.getCanonicalName());
    }

    public FormattingLogger(Class<?> cls) {
        String suffix = "";
        while (cls.isAnonymousClass()) {
            suffix = ".<anonymous_class>" + suffix;
            if (cls.getEnclosingMethod() != null) {
                suffix = "." + cls.getEnclosingMethod().getName() + suffix;
            }
            cls = cls.getEnclosingClass();
        }
        this.logger = Logger.getLogger(cls.getCanonicalName() + suffix);
    }

    public FormattingLogger() {
        this(Logger.getAnonymousLogger());
    }

    public FormattingLogger(Logger logger) {
        if (logger == null) {
            throw new NullPointerException("logger is null");
        }
        this.logger = logger;
    }

    public Logger getFormattingLogger() {
        return this.logger;
    }

    public void log(Level level, String msg, Object ... params) {
        if (!this.isLoggable(level)) {
            return;
        }
        Record record = new Record(level, msg);
        record.setParameters(params);
        this.nameAndLog(record);
    }

    public void log(Level level, String msg, Throwable thrown) {
        if (!this.isLoggable(level)) {
            return;
        }
        Record record = new Record(level, msg);
        record.setThrown(thrown);
        this.nameAndLog(record);
    }

    public void log(Level level, Throwable thrown, String msg, Object ... params) {
        if (!this.isLoggable(level)) {
            return;
        }
        Record record = new Record(level, msg);
        if (thrown != null) {
            record.setThrown(thrown);
        }
        if (params != null && params.length != 0) {
            record.setParameters(params);
        }
        this.nameAndLog(record);
    }

    private void nameAndLog(Record record) {
        if (record.sourceClassName == null || record.sourceMethodName == null) {
            record.setThrowable(new Throwable());
        }
        record.setLoggerName(this.logger.getName());
        this.log(record);
    }

    public void log(LogRecord lr) {
        if (!(lr instanceof Record)) {
            Record rec = new Record(Level.INFO, null);
            lr.setSourceClassName(rec.getSourceClassName());
            lr.setSourceMethodName(rec.getSourceMethodName());
        }
        this.logger.log(lr);
    }

    public void logp(Level level, String sourceClassName, String sourceMethodName, String msg, Object ... params) {
        if (!this.isLoggable(level)) {
            return;
        }
        Record record = new Record(level, msg, sourceClassName, sourceMethodName);
        if (params != null && params.length != 0) {
            record.setParameters(params);
        }
        this.nameAndLog(record);
    }

    public void logp(Level level, String sourceClassName, String sourceMethodName, String msg, Throwable thrown) {
        if (!this.isLoggable(level)) {
            return;
        }
        Record record = new Record(level, msg, sourceClassName, sourceMethodName);
        record.setThrown(thrown);
        this.nameAndLog(record);
    }

    public void logp(Level level, String sourceClassName, String sourceMethodName, Throwable thrown, String msg, Object ... params) {
        if (!this.isLoggable(level)) {
            return;
        }
        Record record = new Record(level, msg, sourceClassName, sourceMethodName);
        if (thrown != null) {
            record.setThrown(thrown);
        }
        if (params != null && params.length != 0) {
            record.setParameters(params);
        }
        this.nameAndLog(record);
    }

    public boolean isLoggable(Level level) {
        return this.logger.isLoggable(level);
    }

    public Level getLevel() {
        return this.logger.getLevel();
    }

    public void setLevel(Level level) {
        this.logger.setLevel(level);
    }

    public void logfmt(Level level, String fmt, Object ... args) {
        if (this.logger.isLoggable(level)) {
            Record record = new Record(level, fmt, args);
            this.nameAndLog(record);
        }
    }

    public void logfmt(Level level, String fmt, Throwable thrown) {
        if (this.logger.isLoggable(level)) {
            Record record = new Record(level, fmt, new Object[]{thrown});
            record.setThrown(thrown);
            this.nameAndLog(record);
        }
    }

    public void logfmt(Level level, Throwable thrown, String fmt, Object ... args) {
        if (this.logger.isLoggable(level)) {
            Record record = new Record(level, fmt, args);
            record.setThrown(thrown);
            this.nameAndLog(record);
        }
    }

    public void logpfmt(Level level, String sourceClassName, String sourceMethodName, String fmt, Object ... args) {
        if (!this.isLoggable(level)) {
            return;
        }
        Record record = new Record(level, fmt, args, sourceClassName, sourceMethodName);
        this.nameAndLog(record);
    }

    public void logpfmt(Level level, String sourceClassName, String sourceMethodName, String fmt, Throwable thrown) {
        if (!this.isLoggable(level)) {
            return;
        }
        Record record = new Record(level, fmt, new Object[]{thrown}, sourceClassName, sourceMethodName);
        record.setThrown(thrown);
        this.nameAndLog(record);
    }

    public void logpfmt(Level level, String sourceClassName, String sourceMethodName, Throwable thrown, String fmt, Object ... args) {
        if (this.logger.isLoggable(level)) {
            this.logp(level, sourceClassName, sourceMethodName, thrown, FormattingLogger.formatSafely(fmt, args), (Object[])null);
        }
    }

    public void severe(String msg, Throwable thrown) {
        this.log(Level.SEVERE, thrown, msg, thrown);
    }

    public void warning(String msg, Throwable thrown) {
        this.log(Level.WARNING, thrown, msg, thrown);
    }

    public void info(String msg, Throwable thrown) {
        this.log(Level.INFO, thrown, msg, thrown);
    }

    public void config(String msg, Throwable thrown) {
        this.log(Level.CONFIG, thrown, msg, thrown);
    }

    public void fine(String msg, Throwable thrown) {
        this.log(Level.FINE, thrown, msg, thrown);
    }

    public void finer(String msg, Throwable thrown) {
        this.log(Level.FINER, thrown, msg, thrown);
    }

    public void finest(String msg, Throwable thrown) {
        this.log(Level.FINEST, thrown, msg, thrown);
    }

    public void severefmt(String fmt, Throwable thrown) {
        this.logfmt(Level.SEVERE, thrown, fmt, thrown);
    }

    public void warningfmt(String fmt, Throwable thrown) {
        this.logfmt(Level.WARNING, thrown, fmt, thrown);
    }

    public void infofmt(String fmt, Throwable thrown) {
        this.logfmt(Level.INFO, thrown, fmt, thrown);
    }

    public void configfmt(String fmt, Throwable thrown) {
        this.logfmt(Level.CONFIG, thrown, fmt, thrown);
    }

    public void finefmt(String fmt, Throwable thrown) {
        this.logfmt(Level.FINE, thrown, fmt, thrown);
    }

    public void finerfmt(String fmt, Throwable thrown) {
        this.logfmt(Level.FINER, thrown, fmt, thrown);
    }

    public void finestfmt(String fmt, Throwable thrown) {
        this.logfmt(Level.FINEST, thrown, fmt, thrown);
    }

    public void severe(String msg, Object ... params) {
        this.log(Level.SEVERE, msg, params);
    }

    public void warning(String msg, Object ... params) {
        this.log(Level.WARNING, msg, params);
    }

    public void info(String msg, Object ... params) {
        this.log(Level.INFO, msg, params);
    }

    public void config(String msg, Object ... params) {
        this.log(Level.CONFIG, msg, params);
    }

    public void fine(String msg, Object ... params) {
        this.log(Level.FINE, msg, params);
    }

    public void finer(String msg, Object ... params) {
        this.log(Level.FINER, msg, params);
    }

    public void finest(String msg, Object ... params) {
        this.log(Level.FINEST, msg, params);
    }

    public void severefmt(String fmt, Object ... args) {
        this.logfmt(Level.SEVERE, fmt, args);
    }

    public void warningfmt(String fmt, Object ... args) {
        this.logfmt(Level.WARNING, fmt, args);
    }

    public void infofmt(String fmt, Object ... args) {
        this.logfmt(Level.INFO, fmt, args);
    }

    public void configfmt(String fmt, Object ... args) {
        this.logfmt(Level.CONFIG, fmt, args);
    }

    public void finefmt(String fmt, Object ... args) {
        this.logfmt(Level.FINE, fmt, args);
    }

    public void finerfmt(String fmt, Object ... args) {
        this.logfmt(Level.FINER, fmt, args);
    }

    public void finestfmt(String fmt, Object ... args) {
        this.logfmt(Level.FINEST, fmt, args);
    }

    public void severe(Throwable thrown, String msg, Object ... params) {
        this.log(Level.SEVERE, thrown, msg, params);
    }

    public void warning(Throwable thrown, String msg, Object ... params) {
        this.log(Level.WARNING, thrown, msg, params);
    }

    public void info(Throwable thrown, String msg, Object ... params) {
        this.log(Level.INFO, thrown, msg, params);
    }

    public void config(Throwable thrown, String msg, Object ... params) {
        this.log(Level.CONFIG, thrown, msg, params);
    }

    public void fine(Throwable thrown, String msg, Object ... params) {
        this.log(Level.FINE, thrown, msg, params);
    }

    public void finer(Throwable thrown, String msg, Object ... params) {
        this.log(Level.FINER, thrown, msg, params);
    }

    public void finest(Throwable thrown, String msg, Object ... params) {
        this.log(Level.FINEST, thrown, msg, params);
    }

    public void severefmt(Throwable thrown, String fmt, Object ... args) {
        this.logfmt(Level.SEVERE, thrown, fmt, args);
    }

    public void warningfmt(Throwable thrown, String fmt, Object ... args) {
        this.logfmt(Level.WARNING, thrown, fmt, args);
    }

    public void infofmt(Throwable thrown, String fmt, Object ... args) {
        this.logfmt(Level.INFO, thrown, fmt, args);
    }

    public void configfmt(Throwable thrown, String fmt, Object ... args) {
        this.logfmt(Level.CONFIG, thrown, fmt, args);
    }

    public void finefmt(Throwable thrown, String fmt, Object ... args) {
        this.logfmt(Level.FINE, thrown, fmt, args);
    }

    public void finerfmt(Throwable thrown, String fmt, Object ... args) {
        this.logfmt(Level.FINER, thrown, fmt, args);
    }

    public void finestfmt(Throwable thrown, String fmt, Object ... args) {
        this.logfmt(Level.FINEST, thrown, fmt, args);
    }

    private static String formatSafely(String fmt, Object ... args) {
        try {
            try {
                return String.format(fmt, args);
            }
            catch (IllegalFormatException e) {
                return String.format("Failed to format message: \"%s\", args: %s", fmt, args != null ? Arrays.toString(args) : "null");
            }
        }
        catch (Exception e) {
            return String.format("Failed to format message: \"%s\"", fmt);
        }
    }

    public static class Record
    extends LogRecord {
        private static final long serialVersionUID = 1L;
        private Throwable throwable;
        private String sourceMethodName;
        private String sourceClassName;
        private transient Object[] formatterArgs;
        private String formatterFormat;

        @Override
        public String getSourceMethodName() {
            if (this.sourceMethodName == null) {
                this.inferCaller();
            }
            return this.sourceMethodName;
        }

        @Override
        public String getSourceClassName() {
            if (this.sourceClassName == null) {
                this.inferCaller();
            }
            return this.sourceClassName;
        }

        public Object[] getFormatterArgs() {
            return this.formatterArgs;
        }

        public String getFormatterFormat() {
            return this.formatterFormat;
        }

        @Override
        public void setSourceClassName(String sourceClassName) {
            this.sourceClassName = sourceClassName;
            super.setSourceClassName(sourceClassName);
        }

        @Override
        public void setSourceMethodName(String sourceMethodName) {
            this.sourceMethodName = sourceMethodName;
            super.setSourceMethodName(sourceMethodName);
        }

        Record(Level level, String msg) {
            super(level, msg);
            this.formatterFormat = null;
            this.formatterArgs = null;
        }

        Record(Level level, String fmt, Object[] args) {
            super(level, FormattingLogger.formatSafely(fmt, args));
            this.formatterFormat = fmt;
            this.formatterArgs = args;
        }

        Record(Level level, String msg, String sourceClassName, String sourceMethodName) {
            super(level, msg);
            this.setSourceClassName(sourceClassName);
            this.setSourceMethodName(sourceMethodName);
            this.formatterFormat = null;
            this.formatterArgs = null;
        }

        Record(Level level, String fmt, Object[] args, String sourceClassName, String sourceMethodName) {
            super(level, FormattingLogger.formatSafely(fmt, args));
            this.setSourceClassName(sourceClassName);
            this.setSourceMethodName(sourceMethodName);
            this.formatterFormat = fmt;
            this.formatterArgs = args;
        }

        private void inferCaller() {
            StackTraceElement ste = this.throwable != null ? CallerFinder.findCaller(this.throwable, FormattingLogger.class, Record.class) : CallerFinder.findCallerOf(FormattingLogger.class);
            this.sourceMethodName = ste.getMethodName();
            this.sourceClassName = ste.getClassName();
        }

        void setThrowable(Throwable t) {
            this.throwable = t;
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            out.defaultWriteObject();
            if (this.formatterArgs == null) {
                out.writeInt(-1);
                return;
            }
            out.writeInt(this.formatterArgs.length);
            for (int i = 0; i < this.formatterArgs.length; ++i) {
                if (this.formatterArgs[i] == null) {
                    out.writeObject(null);
                    continue;
                }
                out.writeObject(this.formatterArgs[i].toString());
            }
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            int len = in.readInt();
            if (len == -1) {
                this.formatterArgs = null;
            } else {
                this.formatterArgs = new Object[len];
                for (int i = 0; i < this.formatterArgs.length; ++i) {
                    this.formatterArgs[i] = in.readObject();
                }
            }
        }
    }
}

