/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.util;

import java.lang.reflect.Method;
import sun.misc.JavaLangAccess;
import sun.misc.SharedSecrets;

public class CallerFinder {
    private static final JavaLangAccess jla = CallerFinder.getJLA();
    private static final Method getStackTraceElementMethod = jla == null ? null : CallerFinder.getGetMethod();

    private static JavaLangAccess getJLA() {
        JavaLangAccess secrets;
        block2: {
            secrets = null;
            try {
                secrets = SharedSecrets.getJavaLangAccess();
            }
            catch (Throwable t) {
                if (!(t instanceof ThreadDeath)) break block2;
                throw (ThreadDeath)t;
            }
        }
        return secrets;
    }

    private static Method getGetMethod() {
        Method method = null;
        try {
            method = JavaLangAccess.class.getMethod("getStackTraceElement", Throwable.class, Integer.TYPE);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return method;
    }

    private CallerFinder() {
    }

    public static StackTraceElement findCaller(Class<?> ... excludedClasses) {
        return CallerFinder.findCaller(new Throwable(), excludedClasses);
    }

    public static StackTraceElement findCaller(Throwable t, Class<?> ... excludedClasses) {
        StackTraceElement[] stack = getStackTraceElementMethod != null ? null : t.getStackTrace();
        int i = 1;
        while (true) {
            block8: {
                StackTraceElement element;
                if (stack == null) {
                    try {
                        element = (StackTraceElement)getStackTraceElementMethod.invoke((Object)jla, t, i);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                } else {
                    element = stack[i];
                }
                String className = element.getClassName();
                if (!className.equals(CallerFinder.class.getName())) {
                    for (Class<?> excludedClass : excludedClasses) {
                        if (!className.equals(excludedClass.getName())) {
                            continue;
                        }
                        break block8;
                    }
                    return element;
                }
            }
            ++i;
        }
    }

    public static StackTraceElement findCallerOf(Class<?> ... classesToFind) {
        return CallerFinder.findCallerOf(new Throwable(), classesToFind);
    }

    public static StackTraceElement findCallerOf(Throwable t, Class<?> ... classesToFind) {
        StackTraceElement[] stack = t.getStackTrace();
        StackTraceElement prevElement = null;
        for (int i = stack.length - 1; i >= 0; --i) {
            StackTraceElement element = stack[i];
            String className = element.getClassName();
            for (Class<?> classToFind : classesToFind) {
                if (!className.equals(classToFind.getName())) continue;
                return prevElement;
            }
            prevElement = element;
        }
        return null;
    }
}

