/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.sql.jdbc.internal.googleapi;

import com.google.api.client.auth.oauth2.TokenResponse;
import com.google.cloud.sql.jdbc.internal.Url;
import com.google.cloud.sql.jdbc.internal.Util;

public class OAuthTokens {
    public static final String REDIRECT_URI = "oob";
    public static final String SCOPE = "https://www.googleapis.com/auth/sqlservice";
    private static final String DEFAULT_CLIENT_ID = "877927577750.apps.googleusercontent.com";
    private static final String DEFAULT_CLIENT_SECRET = "7nBqns87ugMSNBrOM1FdHMK6";
    private final Url url;
    private final String refreshToken;
    private final String accessToken;

    private OAuthTokens(Url url, String refreshToken, String accessToken) {
        this.url = url;
        this.refreshToken = refreshToken;
        this.accessToken = accessToken;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public OAuthTokens withRefreshToken(String refreshToken) {
        return new OAuthTokens(this.url, refreshToken, null);
    }

    public static OAuthTokens fromAccessToken(String accessToken) {
        return new OAuthTokens(null, null, accessToken);
    }

    public static OAuthTokens fromUrl(Url url) {
        return new OAuthTokens(url, url.getOAuth2RefreshToken(), url.getOAuth2AccessToken());
    }

    public OAuthTokens withResponse(TokenResponse response) {
        String refreshToken = Util.isEmpty(response.getRefreshToken()) ? this.refreshToken : response.getRefreshToken();
        return new OAuthTokens(this.url, refreshToken, response.getAccessToken());
    }

    public String getOAuth2ClientId() {
        return OAuthTokens.getOAuth2ClientId(this.url);
    }

    public static String getOAuth2ClientId(Url url) {
        String clientId = url.getOAuth2ClientId();
        return clientId != null ? clientId : DEFAULT_CLIENT_ID;
    }

    public String getOAuth2ClientSecret() {
        String clientSecret = this.url.getOAuth2ClientSecret();
        return clientSecret != null ? clientSecret : DEFAULT_CLIENT_SECRET;
    }
}

