/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.sql.jdbc.internal.googleapi;

import com.google.api.client.auth.oauth2.ClientParametersAuthentication;
import com.google.api.client.auth.oauth2.RefreshTokenRequest;
import com.google.api.client.auth.oauth2.TokenResponse;
import com.google.api.client.auth.oauth2.TokenResponseException;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson.JacksonFactory;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.cloud.sql.jdbc.internal.Url;
import com.google.cloud.sql.jdbc.internal.googleapi.AccessTokenRefresher;
import com.google.cloud.sql.jdbc.internal.googleapi.OAuthTokens;
import java.io.IOException;

public class RefreshTokenAccessTokenRefresher
implements AccessTokenRefresher {
    private final JsonFactory jsonFactory = new JacksonFactory();

    @Override
    public OAuthTokens refreshAccessToken(OAuthTokens tokens, HttpTransport transport, Url url) throws IOException {
        Preconditions.checkNotNull(tokens.getRefreshToken(), "No refresh token.");
        TokenResponse response = null;
        try {
            ClientParametersAuthentication authenticator = new ClientParametersAuthentication(tokens.getOAuth2ClientId(), tokens.getOAuth2ClientSecret());
            GenericUrl gUrl = new GenericUrl(url.getOAuth2TokenUrl());
            response = new RefreshTokenRequest(transport, this.jsonFactory, gUrl, tokens.getRefreshToken()).setClientAuthentication(authenticator).execute();
            return OAuthTokens.fromUrl(url).withResponse(response);
        }
        catch (TokenResponseException e) {
            throw new OAuth2AuthorizationException(e);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    private static class OAuth2AuthorizationException
    extends IOException {
        private static final String INVALID_GRANT_MESSAGE = "The OAuth2 refresh token is not valid. Please delete it and try again. See https://developers.google.com/cloud-sql/docs/commandline#authentication";
        private static final String INVALID_GRANT = "invalid_grant";

        private OAuth2AuthorizationException(TokenResponseException e) {
            super(OAuth2AuthorizationException.createMessage(e));
        }

        private static String createMessage(TokenResponseException e) {
            if (e.getDetails() != null && INVALID_GRANT.equals(e.getDetails().getError())) {
                return INVALID_GRANT_MESSAGE;
            }
            return e.getMessage();
        }
    }
}

