/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.sql.tool;

import com.google.cloud.sql.jdbc.internal.Util;
import com.google.cloud.sql.tool.printers.Printer;
import com.google.cloud.sql.tool.printers.PrinterFactory;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class Results {
    private final ResultSet rs;
    private final float elapsedSeconds;
    private final int fetchSize;
    private final PrinterFactory printerFactory;

    public static Results createResults(ResultSet rs, float elapsedSeconds, int fetchSize, PrinterFactory printerFactory) {
        return new Results(rs, elapsedSeconds, fetchSize, printerFactory);
    }

    private Results(ResultSet rs, float elapsedSeconds, int fetchSize, PrinterFactory printerFactory) {
        this.rs = rs;
        this.elapsedSeconds = elapsedSeconds;
        this.fetchSize = fetchSize;
        this.printerFactory = printerFactory;
    }

    public final int process() throws SQLException {
        ResultSetMetaData md = this.rs.getMetaData();
        int numColumns = md.getColumnCount();
        Printer printer = this.printerFactory.createPrinter(md, this.elapsedSeconds);
        int rowCount = 0;
        int batchCount = 0;
        ArrayList<List<String>> rows = Util.newArrayList();
        while (this.rs.next()) {
            rows.add(Results.createLine(this.rs, numColumns));
            if (++batchCount >= this.fetchSize) {
                Results.showBatchOfRows(printer, rows);
                rows.clear();
                batchCount = 0;
            }
            ++rowCount;
        }
        Results.showBatchOfRows(printer, rows);
        printer.displayFooter(rowCount);
        return rowCount;
    }

    private static void showBatchOfRows(Printer printer, List<List<String>> rows) throws SQLException {
        if (rows.isEmpty()) {
            return;
        }
        printer.displayLines(rows);
    }

    private static List<String> createLine(ResultSet rs, int numColumns) throws SQLException {
        ArrayList<String> row = Util.newArrayListWithCapacity(numColumns);
        for (int i = 1; i <= numColumns; ++i) {
            row.add(rs.getString(i));
        }
        return row;
    }
}

