/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.sql.tool.googleapi;

import com.google.appengine.repackaged.com.google.common.base.Supplier;
import com.google.cloud.sql.jdbc.internal.Url;
import com.google.cloud.sql.jdbc.internal.googleapi.OAuthTokens;
import com.google.cloud.sql.tool.connections.ConnectionException;
import com.google.cloud.sql.tool.connections.ConnectionFactory;
import com.google.cloud.sql.tool.connections.FlagsConnectionFactory;
import com.google.cloud.sql.tool.googleapi.OAuth2ConnectionHelper;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import java.util.prefs.Preferences;

public class OAuth2ConnectionFactory
implements ConnectionFactory {
    private static final String PREFS_PACKAGE = "/com/google/cloud/sqlservice/oauth2";
    private final Preferences prefs;
    private final Supplier<ConnectionFactory> connectionFactoryFactory;
    private final OAuth2ConnectionHelper helper;

    public OAuth2ConnectionFactory() {
        this(Preferences.userRoot().node(PREFS_PACKAGE), new Supplier<ConnectionFactory>(){

            @Override
            public ConnectionFactory get() {
                return new FlagsConnectionFactory();
            }
        }, new OAuth2ConnectionHelper());
    }

    public OAuth2ConnectionFactory(Preferences prefs, Supplier<ConnectionFactory> connectionFactoryFactory, OAuth2ConnectionHelper helper) {
        this.prefs = prefs;
        this.connectionFactoryFactory = connectionFactoryFactory;
        this.helper = helper;
    }

    @Override
    public Connection connect(String urlString, Map<String, String> props) throws ConnectionException, SQLException {
        Url url = Url.createFromMap(urlString, props);
        OAuthTokens tokens = this.getOAuth2Tokens(url);
        if (tokens == null) {
            tokens = this.helper.createOAuth2TokenFlow(url);
            this.saveOAuth2Tokens(url, tokens);
        }
        return this.connectionFactoryFactory.get().connect(urlString, props);
    }

    private OAuthTokens getOAuth2Tokens(Url url) {
        if (url.getOAuth2RefreshToken() != null || url.getOAuth2AccessToken() != null) {
            return OAuthTokens.fromUrl(url);
        }
        String refreshToken = this.prefs.get(url.getOAuth2RefreshTokenKey(), null);
        if (refreshToken == null) {
            return null;
        }
        return OAuthTokens.fromUrl(url).withRefreshToken(refreshToken);
    }

    private void saveOAuth2Tokens(Url url, OAuthTokens tokens) {
        this.prefs.put(url.getOAuth2RefreshTokenKey(), tokens.getRefreshToken());
    }
}

