/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.sql.tool.googleapi;

import com.google.api.client.auth.oauth2.AuthorizationCodeTokenRequest;
import com.google.api.client.auth.oauth2.ClientParametersAuthentication;
import com.google.api.client.auth.oauth2.TokenErrorResponse;
import com.google.api.client.auth.oauth2.TokenResponseException;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson.JacksonFactory;
import com.google.appengine.repackaged.com.google.common.base.Strings;
import com.google.appengine.repackaged.com.google.common.base.Supplier;
import com.google.appengine.repackaged.com.google.common.base.Suppliers;
import com.google.appengine.repackaged.com.google.common.flags.Flag;
import com.google.appengine.repackaged.com.google.common.flags.FlagSpec;
import com.google.cloud.sql.jdbc.internal.Url;
import com.google.cloud.sql.jdbc.internal.Util;
import com.google.cloud.sql.jdbc.internal.googleapi.OAuthTokens;
import com.google.cloud.sql.tool.connections.ConnectionException;
import com.google.cloud.sql.tool.connections.ConsoleSupplier;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class OAuth2ConnectionHelper {
    @FlagSpec(help="Google username (i.e. sqlman@gmail.com) to use to authenticate to the SQL instance.", altName="oauth2_authorization_code")
    private static final Flag<String> oauth2AuthorizationCode = Flag.value("");
    @FlagSpec(help="Show full OAuth2 authorize URL.", altName="oauth2_full_auth_url")
    private static final Flag<Boolean> oauth2FullAuthUrl = Flag.value(false);
    private static final String[] AUTHORIZE_MESSAGE = new String[]{"Please authorize Google SQL Service for your Google Account at:"};
    private static final String SHORT_OAUTH2_AUTHORIZE_URL = "http://goo.gl/Ov319";
    private static final Map<String, String> DEFAULT_ERROR_DESCRIPTIONS = OAuth2ConnectionHelper.createDefaultErrorDescriptions();
    private final HttpTransport transport = new NetHttpTransport();
    private final JsonFactory jsonFactory = new JacksonFactory();

    private static Map<String, String> createDefaultErrorDescriptions() {
        HashMap<String, String> map = Util.newHashMap();
        map.put("invalid_request", "The request is missing a required parameter.");
        map.put("invalid_client", "Client authentication failed (e.g. unknown client, no client authentication included, or unsupported authentication method).");
        map.put("invalid_grant", " The provided authorization grant (e.g. authorization code, resource owner credentials) is invalid, expired, revoked, does not match the redirection URI used in the authorization request, or was issued to another client.");
        map.put("unauthorized_client", "The authenticated client is not authorized to use this authorization grant type.");
        map.put("unsupported_grant_type", "The authorization grant type is not supported by the authorization server.");
        map.put("invalid_scope", "The requested scope is invalid, unknown, malformed,  or exceeds the scope granted by the resource owner.");
        return Collections.unmodifiableMap(map);
    }

    Supplier<String> getAuthorizationCode(Url url) {
        String authorizationCode = oauth2AuthorizationCode.get();
        if (Strings.isNullOrEmpty(authorizationCode)) {
            PrintWriter out = System.console() != null ? System.console().writer() : new PrintWriter(System.out);
            for (String line : OAuth2ConnectionHelper.createAuthorizationMessage(url)) {
                out.println(line);
            }
            return new ConsoleSupplier("Enter Authorization Code");
        }
        return Suppliers.ofInstance(authorizationCode);
    }

    OAuthTokens createOAuth2TokenFlow(Url url) throws ConnectionException {
        String code = this.getAuthorizationCode(url).get();
        if (Strings.isNullOrEmpty(code)) {
            throw new ConnectionException("No access code entered.");
        }
        OAuthTokens tokens = OAuthTokens.fromUrl(url);
        ClientParametersAuthentication authenticator = new ClientParametersAuthentication(tokens.getOAuth2ClientId(), tokens.getOAuth2ClientSecret());
        GenericUrl gUrl = new GenericUrl(url.getOAuth2TokenUrl());
        AuthorizationCodeTokenRequest request = new AuthorizationCodeTokenRequest(this.transport, this.jsonFactory, new GenericUrl(url.getOAuth2TokenUrl()), code).setClientAuthentication(authenticator).setRedirectUri("oob");
        try {
            return tokens.withResponse(request.execute());
        }
        catch (TokenResponseException e) {
            throw new ConnectionException("Unable to fetch OAuth2 tokens: " + OAuth2ConnectionHelper.createErrorDescription(e.getDetails()), e);
        }
        catch (Exception e) {
            throw new ConnectionException("Unable to fetch OAuth2 tokens.", e);
        }
    }

    private static Iterable<String> createAuthorizationMessage(Url url) {
        ArrayList<String> message = Util.newArrayList(AUTHORIZE_MESSAGE);
        message.add(OAuth2ConnectionHelper.createAuthorizeUrl(url));
        return message;
    }

    static String createErrorDescription(TokenErrorResponse response) {
        StringBuilder s = new StringBuilder(response.getError());
        String description = response.getErrorDescription();
        if (description != null) {
            s.append(": ").append(description);
        } else {
            String defaultDescription = DEFAULT_ERROR_DESCRIPTIONS.get(response.getError());
            if (defaultDescription != null) {
                s.append(": ").append(defaultDescription);
            }
        }
        return s.toString();
    }

    private static String createAuthorizeUrl(Url url) {
        if (!oauth2FullAuthUrl.get().booleanValue()) {
            return SHORT_OAUTH2_AUTHORIZE_URL;
        }
        return String.format("%s?response_type=code&scope=%s&redirect_uri=%s&client_id=%s", url.getOAuth2AuthUrl(), "https://www.googleapis.com/auth/sqlservice", "oob", OAuthTokens.getOAuth2ClientId(url));
    }
}

