/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.spi;

import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.spi.FactoryProvider;
import com.google.appengine.spi.FactoryProviderRegistry;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.concurrent.atomic.AtomicReference;

public final class ServiceFactoryFactory {
    private static AtomicReference<FactoryProviderRegistry> explicitRegistry = new AtomicReference<FactoryProviderRegistry>(new FactoryProviderRegistry());

    public static <T> T getFactory(Class<T> base) {
        FactoryProvider<T> p = RuntimeRegistry.runtimeRegistry.getFactoryProvider(base);
        if (p == null) {
            throw new IllegalArgumentException("No provider was registered for " + base.getCanonicalName());
        }
        try {
            return p.getFactoryInstance();
        }
        catch (Exception e) {
            throw new ServiceConfigurationError("Exception while getting factory instance for " + base.getCanonicalName(), e);
        }
    }

    public static synchronized <I> void register(FactoryProvider<I> p) {
        FactoryProviderRegistry temp = explicitRegistry.get();
        Preconditions.checkState(temp != null, "No modifications allowed after calls to getFactoryProvider");
        temp.register(p);
    }

    private static List<FactoryProvider<?>> getProvidersUsingServiceLoader() {
        return (List)AccessController.doPrivileged(new PrivilegedAction<List<FactoryProvider<?>>>(){

            @Override
            public List<FactoryProvider<?>> run() {
                LinkedList result = new LinkedList();
                ClassLoader classLoader = ServiceFactoryFactory.class.getClassLoader();
                ServiceLoader<FactoryProvider> providers = ServiceLoader.load(FactoryProvider.class, classLoader);
                if (providers != null) {
                    for (FactoryProvider provider : providers) {
                        result.add(provider);
                    }
                }
                return result;
            }
        });
    }

    private static final class RuntimeRegistry {
        static final FactoryProviderRegistry runtimeRegistry = new FactoryProviderRegistry();

        private RuntimeRegistry() {
        }

        static {
            FactoryProviderRegistry explicitRegistrations = explicitRegistry.getAndSet(null);
            List providers = ServiceFactoryFactory.getProvidersUsingServiceLoader();
            Collections.sort(providers);
            for (FactoryProvider factoryProvider : providers) {
                FactoryProvider<?> previous;
                Preconditions.checkState(!factoryProvider.equals(previous = runtimeRegistry.register(factoryProvider)), "Ambiguous providers: " + factoryProvider + " versus " + previous);
            }
            for (FactoryProvider factoryProvider : explicitRegistrations.getAllProviders()) {
                runtimeRegistry.register(factoryProvider);
            }
        }
    }
}

