/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.client.datastoreservice.intern;

import com.google.apphosting.datastore.EntityV4;

public class EntityTranslator {
    public static final EntityTranslator DEFAULT = new EntityTranslator();

    public boolean isFormat(Format format, EntityV4.EntityOrBuilder entity) {
        if (entity.getPropertyCount() == 0) {
            return true;
        }
        switch (format) {
            case V1BETA1: {
                if (entity.getProperty(0).hasValue()) break;
                return true;
            }
            case V1BETA2: {
                if (!entity.getProperty(0).hasValue()) break;
                return true;
            }
            default: {
                throw new IllegalArgumentException("Unknown format: " + (Object)((Object)format));
            }
        }
        return false;
    }

    public EntityV4.Entity.Builder toFormat(Format format, EntityV4.Entity.Builder entity) {
        switch (format) {
            case V1BETA1: {
                this.toV1Beta1Format(entity);
                break;
            }
            case V1BETA2: {
                this.toV1Beta2Format(entity);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown format: " + (Object)((Object)format));
            }
        }
        return entity;
    }

    private void toV1Beta2Format(EntityV4.Entity.Builder entity) {
        for (EntityV4.Property.Builder prop : entity.getPropertyBuilderList()) {
            this.toV1Beta2Format(prop);
        }
    }

    private boolean hasEntityWithProperties(EntityV4.ValueOrBuilder value) {
        return value.hasEntityValue() && value.getEntityValueOrBuilder().getPropertyCount() > 0;
    }

    private void toV1Beta2Format(EntityV4.Property.Builder prop) {
        if (prop.getDeprecatedMulti()) {
            EntityV4.Value.Builder value = prop.getValueBuilder();
            value.addAllListValue(prop.getDeprecatedValueList());
            for (int i = 0; i < value.getListValueCount(); ++i) {
                EntityV4.ValueOrBuilder subValue = value.getListValueOrBuilder(i);
                if (!this.hasEntityWithProperties(subValue)) continue;
                this.toV1Beta2Format(value.getListValueBuilder(i).getEntityValueBuilder());
            }
        } else if (prop.getDeprecatedValueCount() > 0) {
            prop.setValue(prop.getDeprecatedValue(0));
            if (this.hasEntityWithProperties(prop.getValueOrBuilder())) {
                this.toV1Beta2Format(prop.getValueBuilder().getEntityValueBuilder());
            }
        }
        prop.clearDeprecatedMulti().clearDeprecatedValue();
    }

    private void toV1Beta1Format(EntityV4.Entity.Builder entity) {
        for (EntityV4.Property.Builder prop : entity.getPropertyBuilderList()) {
            this.toV1Beta1Format(prop);
        }
    }

    private void toV1Beta1Format(EntityV4.Property.Builder prop) {
        if (prop.getValueOrBuilder().getListValueCount() > 0) {
            prop.setDeprecatedMulti(true);
            prop.addAllDeprecatedValue(prop.getValueOrBuilder().getListValueList());
        } else {
            prop.addDeprecatedValue(prop.getValue());
        }
        prop.clearValue();
        for (int i = 0; i < prop.getDeprecatedValueCount(); ++i) {
            EntityV4.ValueOrBuilder value = prop.getDeprecatedValueOrBuilder(i);
            if (!this.hasEntityWithProperties(value)) continue;
            this.toV1Beta1Format(prop.getDeprecatedValueBuilder(i).getEntityValueBuilder());
        }
    }

    public static enum Format {
        V1BETA1,
        V1BETA2;

    }
}

