/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.server.spi.tools;

import com.google.api.server.spi.ServiceContext;
import com.google.api.server.spi.TypeLoader;
import com.google.api.server.spi.config.ApiConfig;
import com.google.api.server.spi.config.ApiConfigException;
import com.google.api.server.spi.config.ApiConfigLoader;
import com.google.api.server.spi.config.ApiConfigSource;
import com.google.api.server.spi.config.ConfigClassPair;
import com.google.api.server.spi.config.annotationreader.ApiConfigAnnotationReader;
import com.google.api.server.spi.config.jsonwriter.JsonConfigWriter;
import com.google.api.server.spi.tools.ApiConfigGenerator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class AnnotationApiConfigGenerator
implements ApiConfigGenerator {
    private final JsonConfigWriter jsonConfigWriter;
    private final ApiConfigLoader configLoader;

    public AnnotationApiConfigGenerator() throws ClassNotFoundException {
        this(new JsonConfigWriter(), AnnotationApiConfigGenerator.class.getClassLoader(), new ApiConfig.Factory());
    }

    public AnnotationApiConfigGenerator(JsonConfigWriter jsonConfigWriter, ClassLoader classLoader, ApiConfig.Factory configFactory) throws ClassNotFoundException {
        this.jsonConfigWriter = jsonConfigWriter;
        this.configLoader = AnnotationApiConfigGenerator.createConfigLoader(configFactory, new TypeLoader(classLoader));
    }

    private static ApiConfigLoader createConfigLoader(ApiConfig.Factory configFactory, TypeLoader typeLoader) {
        return new ApiConfigLoader(configFactory, typeLoader, new ApiConfigAnnotationReader(typeLoader.getAnnotationTypes()), new ApiConfigSource[0]);
    }

    @Override
    public Map<String, String> generateConfig(Class<?> ... serviceClasses) throws ApiConfigException {
        return this.generateConfig(ServiceContext.create(), serviceClasses);
    }

    @Override
    public Map<String, String> generateConfig(ServiceContext serviceContext, Class<?> ... serviceClasses) throws ApiConfigException {
        ArrayList<ConfigClassPair> configs = new ArrayList<ConfigClassPair>();
        for (Class<?> serviceClass : serviceClasses) {
            ApiConfig config = this.configLoader.loadConfiguration(serviceContext, serviceClass);
            ConfigClassPair pair = new ConfigClassPair(config, serviceClass);
            configs.add(pair);
        }
        Map jsonByApiName = this.jsonConfigWriter.writeConfig(serviceContext, configs);
        HashMap<String, String> jsonByFileName = new HashMap<String, String>(jsonByApiName.size());
        for (Map.Entry entry : jsonByApiName.entrySet()) {
            jsonByFileName.put(AnnotationApiConfigGenerator.apiNameToFileName((String)entry.getKey()), (String)entry.getValue());
        }
        return jsonByFileName;
    }

    private static String apiNameToFileName(String apiName) {
        return String.format("%s.api", apiName);
    }
}

