/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.server.spi.tools;

import com.google.api.server.spi.config.ApiConfigException;
import com.google.api.server.spi.tools.DiscoveryDocGenerator;
import com.google.api.server.spi.tools.EndpointsToolAction;
import com.google.api.server.spi.tools.GenApiConfigAction;
import com.google.api.server.spi.tools.GenDiscoveryDocAction;
import com.google.appengine.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.appengine.repackaged.org.codehaus.jackson.JsonGenerationException;
import com.google.appengine.repackaged.org.codehaus.jackson.JsonParseException;
import com.google.appengine.repackaged.org.codehaus.jackson.map.JsonMappingException;
import com.google.appengine.tools.util.Option;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;

public class GetDiscoveryDocAction
extends EndpointsToolAction {
    public static final String NAME = "get-discovery-doc";
    private Option classPathOption = this.makeClassPathOption();
    private Option outputOption = this.makeWarOutputOption();
    private Option miscOutputOption = this.makeMiscOutputOption();
    private Option warOption = this.makeWarOption();

    public GetDiscoveryDocAction() {
        super(NAME);
        this.setOptions(Arrays.asList(this.classPathOption, this.outputOption, this.miscOutputOption, this.warOption));
        this.setShortDescription("Generates API configs and discovery docs");
        this.setHelpDisplayNeeded(true);
    }

    @Override
    public boolean execute() throws JsonGenerationException, JsonMappingException, ClassNotFoundException, IOException, ApiConfigException {
        if (this.getArgs().isEmpty()) {
            return false;
        }
        String warPath = this.getWarPath(this.warOption);
        this.getDiscoveryDoc(GetDiscoveryDocAction.computeClassPath(warPath, this.getClassPath(this.classPathOption)), this.getWarOutputPath(this.outputOption, warPath), warPath, this.getArgs(), this.getOutputPath(this.miscOutputOption));
        return true;
    }

    public String[] getDiscoveryDoc(URL[] classPath, String outputDirPath, String warPath, List<String> serviceClassNames, String miscOutputDirPath) throws JsonGenerationException, JsonMappingException, ClassNotFoundException, IOException, ApiConfigException {
        String[] apiConfigFilePaths = new GenApiConfigAction().genApiConfig(classPath, outputDirPath, warPath, serviceClassNames);
        String[] discoveryDocPaths = new String[apiConfigFilePaths.length];
        int i = 0;
        for (String apiConfigFilePath : apiConfigFilePaths) {
            discoveryDocPaths[i] = this.generateDiscoveryDocs(miscOutputDirPath, apiConfigFilePath);
        }
        return discoveryDocPaths;
    }

    @VisibleForTesting
    String generateDiscoveryDocs(String outputDirPath, String apiConfigFilePath) throws JsonParseException, JsonMappingException, IOException, FileNotFoundException {
        return this.generateDiscoveryDoc(DiscoveryDocGenerator.Format.REST, outputDirPath, apiConfigFilePath);
    }

    @VisibleForTesting
    String generateDiscoveryDoc(DiscoveryDocGenerator.Format format, String outputDirPath, String apiConfigFilePath) throws JsonParseException, JsonMappingException, IOException, FileNotFoundException {
        return new GenDiscoveryDocAction().genDiscoveryDoc(format, outputDirPath, apiConfigFilePath);
    }

    @Override
    public String getUsageString() {
        return "get-discovery-doc <options> <service class>...";
    }
}

