/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.server.spi.tools.devserver;

import com.google.api.server.spi.IoUtil;
import com.google.appengine.repackaged.com.google.api.client.http.GenericUrl;
import com.google.appengine.repackaged.com.google.api.client.http.HttpRequest;
import com.google.appengine.repackaged.com.google.api.client.http.HttpRequestFactory;
import com.google.appengine.repackaged.com.google.api.client.http.HttpResponse;
import com.google.appengine.repackaged.com.google.api.client.http.javanet.NetHttpTransport;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class StaticServlet
extends HttpServlet {
    private static final Logger logger = Logger.getLogger(StaticServlet.class.getName());
    private Map<String, String> staticContent = new HashMap<String, String>();

    public void init() throws ServletException {
        super.init();
        try {
            this.cacheContent("/proxy.html");
        }
        catch (IOException e) {
            throw new ServletException((Throwable)e);
        }
    }

    private void cacheContent(String path) throws IOException {
        String content = this.getStaticContent(path);
        this.staticContent.put(path, content);
    }

    private String getStaticContent(String path) throws IOException {
        String url = "https://webapis-discovery.appspot.com/_ah/api/static" + path;
        HttpRequestFactory requestFactory = new NetHttpTransport().createRequestFactory();
        HttpRequest request = requestFactory.buildGetRequest(new GenericUrl(url));
        HttpResponse response = request.execute();
        int statusCode = response.getStatusCode();
        if (statusCode >= 300) {
            throw new IOException(MessageFormat.format("Failed to get static content at {0}. HTTP code {1}. Response body {2}.", url, statusCode, response.getContent().toString()));
        }
        return IoUtil.readStream((InputStream)response.getContent());
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String path = request.getPathInfo();
        String responseBody = this.staticContent.get(path);
        if (responseBody != null) {
            response.setContentType("text/html");
            response.getWriter().print(responseBody);
        } else {
            logger.log(Level.WARNING, "No content found for path {0}", path);
            response.sendError(404);
        }
    }
}

