/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.client.datastoreservice.intern;

import com.google.appengine.repackaged.com.google.common.base.Function;
import com.google.appengine.repackaged.com.google.common.collect.Lists;
import com.google.appengine.repackaged.com.google.net.util.error.Codes;
import com.google.appengine.repackaged.com.google.protobuf.InvalidProtocolBufferException;
import com.google.appengine.repackaged.com.google.protobuf.Parser;
import com.google.apphosting.client.datastoreservice.intern.DatastoreRpcHandler;
import com.google.apphosting.client.datastoreservice.intern.EntityV4Normalizer;
import com.google.apphosting.client.datastoreservice.intern.InternDatastoreRpcService;
import com.google.apphosting.client.datastoreservice.intern.LookupHandler;
import com.google.apphosting.client.datastoreservice.proto.DatastoreService;
import com.google.apphosting.client.serviceapp.RpcException;
import com.google.apphosting.client.serviceapp.RpcHandler;
import com.google.apphosting.datastore.DatastoreV4;
import com.google.apphosting.datastore.EntityV4;
import java.util.ArrayList;

class RunQueryHandler
extends DatastoreRpcHandler<DatastoreService.RunQueryRequest, DatastoreService.RunQueryResponse> {
    static final InternDatastoreRpcService.RpcSpec<DatastoreV4.RunQueryResponse> INTERN_RPC_SPEC = InternDatastoreRpcService.createRpcSpec("datastore_v4", "RunQuery", DatastoreV4.RunQueryResponse.PARSER);
    static final InternDatastoreRpcService.RpcSpec<DatastoreV4.ContinueQueryResponse> INTERN_CONTINUE_RPC_SPEC = InternDatastoreRpcService.createRpcSpec("datastore_v4", "ContinueQuery", DatastoreV4.ContinueQueryResponse.PARSER);
    private final EntityV4Normalizer defaultEntityNormalizer;
    private final Function<DatastoreV4.EntityResult, DatastoreService.EntityResult> outputEntityResultTransform;

    public RunQueryHandler(InternDatastoreRpcService internService, EntityV4Normalizer defaultEntityNormalizer, Function<DatastoreV4.EntityResult, DatastoreService.EntityResult> outputEntityResultTransform) {
        super(internService);
        this.defaultEntityNormalizer = defaultEntityNormalizer;
        this.outputEntityResultTransform = outputEntityResultTransform;
    }

    @Override
    public Parser<DatastoreService.RunQueryRequest> getParser() {
        return DatastoreService.RunQueryRequest.PARSER;
    }

    @Override
    public DatastoreService.RunQueryResponse call(RpcHandler.CallOptions options, DatastoreService.RunQueryRequest req) throws RpcException {
        DatastoreService.RunQueryResponse.Builder res = DatastoreService.RunQueryResponse.newBuilder();
        DatastoreService.QueryResultBatch.Builder batch = res.getBatchBuilder();
        DatastoreV4.RunQueryResponse initialInternResp = this.internService.call(INTERN_RPC_SPEC, this.toV4RunQueryRequest(req)).getResponse();
        DatastoreV4.QueryResultBatch internBatch = initialInternResp.getBatch();
        batch.setEntityResultType(DatastoreService.EntityResult.ResultType.valueOf(internBatch.getEntityResultType().getNumber()));
        DatastoreV4.ContinueQueryRequest continueReq = DatastoreV4.ContinueQueryRequest.newBuilder().setQueryHandle(initialInternResp.getQueryHandle()).build();
        int currentSerializeResultBytes = 0;
        while (true) {
            InternDatastoreRpcService.ResponseFutureWrapper<DatastoreV4.ContinueQueryResponse> nextFutureWrapper = internBatch.getMoreResults() == DatastoreV4.QueryResultBatch.MoreResultsType.NOT_FINISHED ? this.internService.call(INTERN_CONTINUE_RPC_SPEC, continueReq) : null;
            ArrayList<DatastoreService.EntityResult> convertedResults = Lists.newArrayListWithCapacity(internBatch.getEntityResultCount());
            for (DatastoreService.EntityResult result : Lists.transform(internBatch.getEntityResultList(), this.outputEntityResultTransform)) {
                int serializedSize = result.getSerializedSize() + 10;
                if (currentSerializeResultBytes + serializedSize > options.getMaxResponseBytes()) {
                    batch.setMoreResults(DatastoreService.QueryResultBatch.MoreResultsType.NOT_FINISHED);
                    return res.build();
                }
                currentSerializeResultBytes += serializedSize;
                convertedResults.add(result);
            }
            batch.addAllEntityResult(convertedResults);
            batch.setEndCursor(internBatch.getEndCursor());
            if (internBatch.hasSkippedResults()) {
                batch.setSkippedResults(batch.getSkippedResults() + internBatch.getSkippedResults());
            }
            if (nextFutureWrapper == null) {
                batch.setMoreResults(DatastoreService.QueryResultBatch.MoreResultsType.valueOf(internBatch.getMoreResults().getNumber()));
                return res.build();
            }
            internBatch = nextFutureWrapper.getResponse().getBatch();
        }
    }

    @Override
    public DatastoreService.RunQueryResponse makeError(Codes.Code errorCode, String message) {
        return DatastoreService.RunQueryResponse.newBuilder().setHeader(RunQueryHandler.makeErrorHeader(errorCode, message)).build();
    }

    private void normalizeQueryFilter(EntityV4Normalizer entityNormalizer, DatastoreV4.Filter.Builder filter) {
        if (filter.hasCompositeFilter()) {
            for (DatastoreV4.Filter.Builder subFilter : filter.getCompositeFilterBuilder().getFilterBuilderList()) {
                this.normalizeQueryFilter(entityNormalizer, subFilter);
            }
        }
        if (filter.hasPropertyFilter()) {
            DatastoreV4.PropertyFilter.Builder propertyFilter = filter.getPropertyFilterBuilder();
            propertyFilter.setValue(entityNormalizer.normalizeValue(propertyFilter.getValue()));
        }
    }

    private DatastoreV4.Query toV4Query(EntityV4Normalizer entityNormalizer, DatastoreService.Query apiQuery) {
        DatastoreV4.Query.Builder intQuery = DatastoreV4.Query.newBuilder();
        try {
            intQuery.mergeFrom(apiQuery.toByteString());
        }
        catch (InvalidProtocolBufferException e) {
            throw new IllegalStateException(String.format("The %s message could not be parsed with the %s parser.", apiQuery.getClass(), DatastoreV4.Query.PARSER.getClass()), e);
        }
        if (intQuery.hasFilter()) {
            this.normalizeQueryFilter(entityNormalizer, intQuery.getFilterBuilder());
        }
        return intQuery.build();
    }

    private void normalizeGqlQueryArg(EntityV4Normalizer entityNormalizer, DatastoreV4.GqlQueryArg.Builder gqlQueryArg) {
        if (gqlQueryArg.hasValue()) {
            gqlQueryArg.setValue(entityNormalizer.normalizeValue(gqlQueryArg.getValue()));
        }
    }

    private DatastoreV4.GqlQuery toV4GqlQuery(EntityV4Normalizer entityNormalizer, DatastoreService.GqlQuery apiGqlQuery) {
        DatastoreV4.GqlQuery.Builder intGqlQuery = DatastoreV4.GqlQuery.newBuilder();
        try {
            intGqlQuery.mergeFrom(apiGqlQuery.toByteString());
        }
        catch (InvalidProtocolBufferException e) {
            throw new IllegalStateException(String.format("The %s message could not be parsed with the %s parser.", apiGqlQuery.getClass(), DatastoreV4.GqlQuery.PARSER.getClass()), e);
        }
        for (DatastoreV4.GqlQueryArg.Builder nameArg : intGqlQuery.getNameArgBuilderList()) {
            this.normalizeGqlQueryArg(entityNormalizer, nameArg);
        }
        for (DatastoreV4.GqlQueryArg.Builder numberArg : intGqlQuery.getNumberArgBuilderList()) {
            this.normalizeGqlQueryArg(entityNormalizer, numberArg);
        }
        return intGqlQuery.build();
    }

    DatastoreV4.RunQueryRequest toV4RunQueryRequest(DatastoreService.RunQueryRequest request) {
        DatastoreV4.RunQueryRequest.Builder internRequest = DatastoreV4.RunQueryRequest.newBuilder();
        EntityV4.PartitionId internContextPartitionId = this.defaultEntityNormalizer.normalizePartitionId(request.getPartitionId());
        EntityV4Normalizer entityNormalizer = this.defaultEntityNormalizer.overrideDefaultPartitionId(internContextPartitionId);
        internRequest.setPartitionId(internContextPartitionId);
        if (request.hasQuery()) {
            internRequest.setQuery(this.toV4Query(entityNormalizer, request.getQuery()));
        }
        if (request.hasGqlQuery()) {
            internRequest.setGqlQuery(this.toV4GqlQuery(entityNormalizer, request.getGqlQuery()));
        }
        internRequest.setSuggestedBatchSize(Integer.MAX_VALUE);
        if (request.hasReadOptions()) {
            internRequest.setReadOptions(LookupHandler.READ_OPTIONS_CONVERTER.apply(request.getReadOptions()));
        }
        return internRequest.build();
    }
}

