/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.client.datastoreservice.intern;

import com.google.appengine.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.appengine.repackaged.com.google.common.base.Function;
import com.google.appengine.repackaged.com.google.common.collect.Lists;
import com.google.appengine.repackaged.com.google.net.util.error.Codes;
import com.google.appengine.repackaged.com.google.protobuf.Parser;
import com.google.apphosting.client.datastoreservice.intern.DatastoreRpcHandler;
import com.google.apphosting.client.datastoreservice.intern.InternDatastoreRpcService;
import com.google.apphosting.client.datastoreservice.proto.DatastoreService;
import com.google.apphosting.client.serviceapp.RpcException;
import com.google.apphosting.client.serviceapp.RpcHandler;
import com.google.apphosting.datastore.DatastoreV4;
import com.google.apphosting.datastore.EntityV4;

class CommitHandler
extends DatastoreRpcHandler<DatastoreService.CommitRequest, DatastoreService.CommitResponse> {
    @VisibleForTesting
    static final InternDatastoreRpcService.RpcSpec<DatastoreV4.CommitResponse> INTERN_RPC_SPEC = InternDatastoreRpcService.createRpcSpec("datastore_v4", "Commit", DatastoreV4.CommitResponse.PARSER);
    private final Function<EntityV4.Key, EntityV4.Key> inputKeyTransform;
    private final Function<EntityV4.Entity, EntityV4.Entity> inputEntityTransform;

    public CommitHandler(InternDatastoreRpcService internService, Function<EntityV4.Key, EntityV4.Key> inputKeyTransform, Function<EntityV4.Entity, EntityV4.Entity> inputEntityTransform) {
        super(internService);
        this.inputKeyTransform = inputKeyTransform;
        this.inputEntityTransform = inputEntityTransform;
    }

    @Override
    public Parser<DatastoreService.CommitRequest> getParser() {
        return DatastoreService.CommitRequest.PARSER;
    }

    @Override
    public DatastoreService.CommitResponse call(RpcHandler.CallOptions options, DatastoreService.CommitRequest req) throws RpcException {
        DatastoreV4.CommitRequest.Builder internReq = DatastoreV4.CommitRequest.newBuilder();
        if (req.hasTransaction()) {
            internReq.setTransaction(req.getTransaction());
        }
        if (req.hasMode()) {
            internReq.setMode(DatastoreV4.CommitRequest.Mode.valueOf(req.getMode().getNumber()));
        }
        if (req.hasMutation()) {
            internReq.setMutation(this.convertMutation(req.getMutation()));
        }
        DatastoreV4.CommitResponse internRes = this.internService.call(INTERN_RPC_SPEC, internReq.build()).getResponse();
        DatastoreService.CommitResponse.Builder res = DatastoreService.CommitResponse.newBuilder();
        if (internRes.hasMutationResult()) {
            res.setMutationResult(this.convertMutationResult(internRes.getMutationResult()));
        }
        return res.build();
    }

    private DatastoreV4.Mutation convertMutation(DatastoreService.Mutation mutation) {
        DatastoreV4.Mutation.Builder internMutation = DatastoreV4.Mutation.newBuilder();
        internMutation.addAllUpsert(Lists.transform(mutation.getUpsertList(), this.inputEntityTransform));
        internMutation.addAllUpdate(Lists.transform(mutation.getUpdateList(), this.inputEntityTransform));
        internMutation.addAllInsert(Lists.transform(mutation.getInsertList(), this.inputEntityTransform));
        internMutation.addAllInsertAutoId(Lists.transform(mutation.getInsertAutoIdList(), this.inputEntityTransform));
        internMutation.addAllDelete(Lists.transform(mutation.getDeleteList(), this.inputKeyTransform));
        if (mutation.hasForce()) {
            internMutation.setForce(mutation.getForce());
        }
        return internMutation.build();
    }

    DatastoreService.MutationResult convertMutationResult(DatastoreV4.MutationResult internMutationResult) {
        DatastoreService.MutationResult.Builder apiMutationResult = DatastoreService.MutationResult.newBuilder();
        apiMutationResult.setIndexUpdates(internMutationResult.getIndexUpdates());
        apiMutationResult.addAllInsertAutoIdKey(internMutationResult.getInsertAutoIdKeyList());
        return apiMutationResult.build();
    }

    @Override
    public DatastoreService.CommitResponse makeError(Codes.Code errorCode, String message) {
        return DatastoreService.CommitResponse.newBuilder().setHeader(CommitHandler.makeErrorHeader(errorCode, message)).build();
    }
}

