package com.google.appengine.api.labs.modules;

import com.google.appengine.spi.ServiceFactoryFactory;

/**
 * Factory for getting an implementation of the {@link ModulesService}.
 *
 * @see ModulesService
 */
public class ModulesServiceFactory {

  /**
   * Returns an implementation of {@link ModulesService} for the current environment.
   */
  public static ModulesService getModulesService() {
    return ServiceFactoryFactory.getFactory(IModulesServiceFactory.class).getModulesService();
  }

  private ModulesServiceFactory() { }
}
