

  package com.google.appengine.api.search.query;

import org.antlr.runtime.*;

public class ExpressionLexer extends Lexer {
    public static final int DOLLAR=54;
    public static final int EXPONENT=49;
    public static final int LT=11;
    public static final int LSQUARE=23;
    public static final int ASCII_LETTER=52;
    public static final int LOG=40;
    public static final int SNIPPET=44;
    public static final int OCTAL_ESC=57;
    public static final int MAX=41;
    public static final int COUNT=37;
    public static final int FLOAT=33;
    public static final int NAME_START=50;
    public static final int HTML=28;
    public static final int NOT=10;
    public static final int ATOM=29;
    public static final int AND=7;
    public static final int EOF=-1;
    public static final int LPAREN=21;
    public static final int INDEX=5;
    public static final int QUOTE=47;
    public static final int RPAREN=22;
    public static final int DISTANCE=38;
    public static final int T__58=58;
    public static final int NAME=26;
    public static final int ESC_SEQ=48;
    public static final int POW=43;
    public static final int COMMA=35;
    public static final int PLUS=17;
    public static final int GEO=32;
    public static final int DIGIT=46;
    public static final int EQ=15;
    public static final int NE=16;
    public static final int GE=14;
    public static final int XOR=9;
    public static final int SWITCH=45;
    public static final int UNICODE_ESC=56;
    public static final int NUMBER=31;
    public static final int HEX_DIGIT=55;
    public static final int UNDERSCORE=53;
    public static final int INT=24;
    public static final int MIN=42;
    public static final int TEXT=27;
    public static final int RSQUARE=25;
    public static final int MINUS=18;
    public static final int GEOPOINT=39;
    public static final int PHRASE=34;
    public static final int ABS=36;
    public static final int WS=51;
    public static final int NEG=4;
    public static final int OR=8;
    public static final int GT=13;
    public static final int DIV=20;
    public static final int DATE=30;
    public static final int TIMES=19;
    public static final int COND=6;
    public static final int LE=12;

    public ExpressionLexer() {;}
    public ExpressionLexer(CharStream input) {
        this(input, new RecognizerSharedState());
    }
    public ExpressionLexer(CharStream input, RecognizerSharedState state) {
        super(input,state);

    }
    public String getGrammarFileName() { return ""; }

    public final void mT__58() throws RecognitionException {
        try {
            int _type = T__58;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            {
            match('.');

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }

    public final void mABS() throws RecognitionException {
        try {
            int _type = ABS;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            {
            match("abs");

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }

    public final void mCOUNT() throws RecognitionException {
        try {
            int _type = COUNT;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            {
            match("count");

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }

    public final void mDISTANCE() throws RecognitionException {
        try {
            int _type = DISTANCE;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            {
            match("distance");

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }

    public final void mGEOPOINT() throws RecognitionException {
        try {
            int _type = GEOPOINT;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            {
            match("geopoint");

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }

    public final void mLOG() throws RecognitionException {
        try {
            int _type = LOG;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            {
            match("log");

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }

    public final void mMAX() throws RecognitionException {
        try {
            int _type = MAX;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            {
            match("max");

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }

    public final void mMIN() throws RecognitionException {
        try {
            int _type = MIN;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            {
            match("min");

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }

    public final void mPOW() throws RecognitionException {
        try {
            int _type = POW;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            {
            match("pow");

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }

    public final void mAND() throws RecognitionException {
        try {
            int _type = AND;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            {
            match("AND");

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }

    public final void mOR() throws RecognitionException {
        try {
            int _type = OR;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            {
            match("OR");

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }

    public final void mXOR() throws RecognitionException {
        try {
            int _type = XOR;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            {
            match("XOR");

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }

    public final void mNOT() throws RecognitionException {
        try {
            int _type = NOT;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            {
            match("NOT");

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }

    public final void mSNIPPET() throws RecognitionException {
        try {
            int _type = SNIPPET;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            {
            match("snippet");

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }

    public final void mSWITCH() throws RecognitionException {
        try {
            int _type = SWITCH;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            {
            match("switch");

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }

    public final void mTEXT() throws RecognitionException {
        try {
            int _type = TEXT;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            {
            match("text");

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }

    public final void mHTML() throws RecognitionException {
        try {
            int _type = HTML;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            {
            match("html");

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }

    public final void mATOM() throws RecognitionException {
        try {
            int _type = ATOM;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            {
            match("atom");

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }

    public final void mDATE() throws RecognitionException {
        try {
            int _type = DATE;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            {
            match("date");

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }

    public final void mNUMBER() throws RecognitionException {
        try {
            int _type = NUMBER;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            {
            match("number");

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }

    public final void mGEO() throws RecognitionException {
        try {
            int _type = GEO;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            {
            match("geo");

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }

    public final void mINT() throws RecognitionException {
        try {
            int _type = INT;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            {
            int alt1=2;
            int LA1_0 = input.LA(1);

            if ( (LA1_0=='-') ) {
                alt1=1;
            }
            switch (alt1) {
                case 1 :
                    {
                    match('-');

                    }
                    break;

            }

            int cnt2=0;
            loop2:
            do {
                int alt2=2;
                int LA2_0 = input.LA(1);

                if ( ((LA2_0>='0' && LA2_0<='9')) ) {
                    alt2=1;
                }

                switch (alt2) {
            	case 1 :
            	    {
            	    mDIGIT();

            	    }
            	    break;

            	default :
            	    if ( cnt2 >= 1 ) break loop2;
                        EarlyExitException eee =
                            new EarlyExitException(2, input);
                        throw eee;
                }
                cnt2++;
            } while (true);

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }

    public final void mPHRASE() throws RecognitionException {
        try {
            int _type = PHRASE;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            {
            mQUOTE();
            loop3:
            do {
                int alt3=3;
                int LA3_0 = input.LA(1);

                if ( (LA3_0=='\\') ) {
                    alt3=1;
                }
                else if ( ((LA3_0>='\u0000' && LA3_0<='!')||(LA3_0>='#' && LA3_0<='[')||(LA3_0>=']' && LA3_0<='\uFFFF')) ) {
                    alt3=2;
                }

                switch (alt3) {
            	case 1 :
            	    {
            	    mESC_SEQ();

            	    }
            	    break;
            	case 2 :
            	    {
            	    if ( (input.LA(1)>='\u0000' && input.LA(1)<='!')||(input.LA(1)>='#' && input.LA(1)<='[')||(input.LA(1)>=']' && input.LA(1)<='\uFFFF') ) {
            	        input.consume();

            	    }
            	    else {
            	        MismatchedSetException mse = new MismatchedSetException(null,input);
            	        recover(mse);
            	        throw mse;}

            	    }
            	    break;

            	default :
            	    break loop3;
                }
            } while (true);

            mQUOTE();

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }

    public final void mFLOAT() throws RecognitionException {
        try {
            int _type = FLOAT;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            int alt13=3;
            alt13 = dfa13.predict(input);
            switch (alt13) {
                case 1 :
                    {
                    int alt4=2;
                    int LA4_0 = input.LA(1);

                    if ( (LA4_0=='-') ) {
                        alt4=1;
                    }
                    switch (alt4) {
                        case 1 :
                            {
                            match('-');

                            }
                            break;

                    }

                    int cnt5=0;
                    loop5:
                    do {
                        int alt5=2;
                        int LA5_0 = input.LA(1);

                        if ( ((LA5_0>='0' && LA5_0<='9')) ) {
                            alt5=1;
                        }

                        switch (alt5) {
                    	case 1 :
                    	    {
                    	    mDIGIT();

                    	    }
                    	    break;

                    	default :
                    	    if ( cnt5 >= 1 ) break loop5;
                                EarlyExitException eee =
                                    new EarlyExitException(5, input);
                                throw eee;
                        }
                        cnt5++;
                    } while (true);

                    match('.');
                    loop6:
                    do {
                        int alt6=2;
                        int LA6_0 = input.LA(1);

                        if ( ((LA6_0>='0' && LA6_0<='9')) ) {
                            alt6=1;
                        }

                        switch (alt6) {
                    	case 1 :
                    	    {
                    	    mDIGIT();

                    	    }
                    	    break;

                    	default :
                    	    break loop6;
                        }
                    } while (true);

                    int alt7=2;
                    int LA7_0 = input.LA(1);

                    if ( (LA7_0=='E'||LA7_0=='e') ) {
                        alt7=1;
                    }
                    switch (alt7) {
                        case 1 :
                            {
                            mEXPONENT();

                            }
                            break;

                    }

                    }
                    break;
                case 2 :
                    {
                    int alt8=2;
                    int LA8_0 = input.LA(1);

                    if ( (LA8_0=='-') ) {
                        alt8=1;
                    }
                    switch (alt8) {
                        case 1 :
                            {
                            match('-');

                            }
                            break;

                    }

                    match('.');
                    int cnt9=0;
                    loop9:
                    do {
                        int alt9=2;
                        int LA9_0 = input.LA(1);

                        if ( ((LA9_0>='0' && LA9_0<='9')) ) {
                            alt9=1;
                        }

                        switch (alt9) {
                    	case 1 :
                    	    {
                    	    mDIGIT();

                    	    }
                    	    break;

                    	default :
                    	    if ( cnt9 >= 1 ) break loop9;
                                EarlyExitException eee =
                                    new EarlyExitException(9, input);
                                throw eee;
                        }
                        cnt9++;
                    } while (true);

                    int alt10=2;
                    int LA10_0 = input.LA(1);

                    if ( (LA10_0=='E'||LA10_0=='e') ) {
                        alt10=1;
                    }
                    switch (alt10) {
                        case 1 :
                            {
                            mEXPONENT();

                            }
                            break;

                    }

                    }
                    break;
                case 3 :
                    {
                    int alt11=2;
                    int LA11_0 = input.LA(1);

                    if ( (LA11_0=='-') ) {
                        alt11=1;
                    }
                    switch (alt11) {
                        case 1 :
                            {
                            match('-');

                            }
                            break;

                    }

                    int cnt12=0;
                    loop12:
                    do {
                        int alt12=2;
                        int LA12_0 = input.LA(1);

                        if ( ((LA12_0>='0' && LA12_0<='9')) ) {
                            alt12=1;
                        }

                        switch (alt12) {
                    	case 1 :
                    	    {
                    	    mDIGIT();

                    	    }
                    	    break;

                    	default :
                    	    if ( cnt12 >= 1 ) break loop12;
                                EarlyExitException eee =
                                    new EarlyExitException(12, input);
                                throw eee;
                        }
                        cnt12++;
                    } while (true);

                    mEXPONENT();

                    }
                    break;

            }
            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }

    public final void mNAME() throws RecognitionException {
        try {
            int _type = NAME;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            {
            mNAME_START();
            loop14:
            do {
                int alt14=2;
                int LA14_0 = input.LA(1);

                if ( (LA14_0=='$'||(LA14_0>='0' && LA14_0<='9')||(LA14_0>='A' && LA14_0<='Z')||LA14_0=='_'||(LA14_0>='a' && LA14_0<='z')) ) {
                    alt14=1;
                }

                switch (alt14) {
            	case 1 :
            	    {
            	    if ( input.LA(1)=='$'||(input.LA(1)>='0' && input.LA(1)<='9')||(input.LA(1)>='A' && input.LA(1)<='Z')||input.LA(1)=='_'||(input.LA(1)>='a' && input.LA(1)<='z') ) {
            	        input.consume();

            	    }
            	    else {
            	        MismatchedSetException mse = new MismatchedSetException(null,input);
            	        recover(mse);
            	        throw mse;}

            	    }
            	    break;

            	default :
            	    break loop14;
                }
            } while (true);

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }

    public final void mLPAREN() throws RecognitionException {
        try {
            int _type = LPAREN;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            {
            match('(');

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }

    public final void mRPAREN() throws RecognitionException {
        try {
            int _type = RPAREN;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            {
            match(')');

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }

    public final void mLSQUARE() throws RecognitionException {
        try {
            int _type = LSQUARE;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            {
            match('[');

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }

    public final void mRSQUARE() throws RecognitionException {
        try {
            int _type = RSQUARE;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            {
            match(']');

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }

    public final void mPLUS() throws RecognitionException {
        try {
            int _type = PLUS;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            {
            match('+');

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }

    public final void mMINUS() throws RecognitionException {
        try {
            int _type = MINUS;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            {
            match('-');

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }

    public final void mTIMES() throws RecognitionException {
        try {
            int _type = TIMES;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            {
            match('*');

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }

    public final void mDIV() throws RecognitionException {
        try {
            int _type = DIV;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            {
            match('/');

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }

    public final void mLT() throws RecognitionException {
        try {
            int _type = LT;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            {
            match('<');

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }

    public final void mLE() throws RecognitionException {
        try {
            int _type = LE;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            {
            match("<=");

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }

    public final void mGT() throws RecognitionException {
        try {
            int _type = GT;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            {
            match('>');

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }

    public final void mGE() throws RecognitionException {
        try {
            int _type = GE;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            {
            match(">=");

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }

    public final void mEQ() throws RecognitionException {
        try {
            int _type = EQ;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            {
            match('=');

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }

    public final void mNE() throws RecognitionException {
        try {
            int _type = NE;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            {
            match("!=");

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }

    public final void mCOND() throws RecognitionException {
        try {
            int _type = COND;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            {
            match('?');

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }

    public final void mQUOTE() throws RecognitionException {
        try {
            int _type = QUOTE;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            {
            match('\"');

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }

    public final void mCOMMA() throws RecognitionException {
        try {
            int _type = COMMA;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            {
            match(',');

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }

    public final void mWS() throws RecognitionException {
        try {
            int _type = WS;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            {
            int cnt15=0;
            loop15:
            do {
                int alt15=2;
                int LA15_0 = input.LA(1);

                if ( ((LA15_0>='\t' && LA15_0<='\n')||LA15_0=='\r'||LA15_0==' ') ) {
                    alt15=1;
                }

                switch (alt15) {
            	case 1 :
            	    {
            	    if ( (input.LA(1)>='\t' && input.LA(1)<='\n')||input.LA(1)=='\r'||input.LA(1)==' ' ) {
            	        input.consume();

            	    }
            	    else {
            	        MismatchedSetException mse = new MismatchedSetException(null,input);
            	        recover(mse);
            	        throw mse;}

            	    }
            	    break;

            	default :
            	    if ( cnt15 >= 1 ) break loop15;
                        EarlyExitException eee =
                            new EarlyExitException(15, input);
                        throw eee;
                }
                cnt15++;
            } while (true);

            _channel = HIDDEN;

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }

    public final void mEXPONENT() throws RecognitionException {
        try {
            {
            if ( input.LA(1)=='E'||input.LA(1)=='e' ) {
                input.consume();

            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                recover(mse);
                throw mse;}

            int alt16=2;
            int LA16_0 = input.LA(1);

            if ( (LA16_0=='+'||LA16_0=='-') ) {
                alt16=1;
            }
            switch (alt16) {
                case 1 :
                    {
                    if ( input.LA(1)=='+'||input.LA(1)=='-' ) {
                        input.consume();

                    }
                    else {
                        MismatchedSetException mse = new MismatchedSetException(null,input);
                        recover(mse);
                        throw mse;}

                    }
                    break;

            }

            int cnt17=0;
            loop17:
            do {
                int alt17=2;
                int LA17_0 = input.LA(1);

                if ( ((LA17_0>='0' && LA17_0<='9')) ) {
                    alt17=1;
                }

                switch (alt17) {
            	case 1 :
            	    {
            	    mDIGIT();

            	    }
            	    break;

            	default :
            	    if ( cnt17 >= 1 ) break loop17;
                        EarlyExitException eee =
                            new EarlyExitException(17, input);
                        throw eee;
                }
                cnt17++;
            } while (true);

            }

        }
        finally {
        }
    }

    public final void mNAME_START() throws RecognitionException {
        try {
            {
            if ( input.LA(1)=='$'||(input.LA(1)>='A' && input.LA(1)<='Z')||input.LA(1)=='_'||(input.LA(1)>='a' && input.LA(1)<='z') ) {
                input.consume();

            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                recover(mse);
                throw mse;}

            }

        }
        finally {
        }
    }

    public final void mASCII_LETTER() throws RecognitionException {
        try {
            {
            if ( (input.LA(1)>='A' && input.LA(1)<='Z')||(input.LA(1)>='a' && input.LA(1)<='z') ) {
                input.consume();

            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                recover(mse);
                throw mse;}

            }

        }
        finally {
        }
    }

    public final void mDIGIT() throws RecognitionException {
        try {
            {
            matchRange('0','9');

            }

        }
        finally {
        }
    }

    public final void mDOLLAR() throws RecognitionException {
        try {
            {
            match('$');

            }

        }
        finally {
        }
    }

    public final void mUNDERSCORE() throws RecognitionException {
        try {
            {
            match('_');

            }

        }
        finally {
        }
    }

    public final void mHEX_DIGIT() throws RecognitionException {
        try {
            {
            if ( (input.LA(1)>='0' && input.LA(1)<='9')||(input.LA(1)>='A' && input.LA(1)<='F')||(input.LA(1)>='a' && input.LA(1)<='f') ) {
                input.consume();

            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                recover(mse);
                throw mse;}

            }

        }
        finally {
        }
    }

    public final void mESC_SEQ() throws RecognitionException {
        try {
            int alt18=3;
            int LA18_0 = input.LA(1);

            if ( (LA18_0=='\\') ) {
                switch ( input.LA(2) ) {
                case '\"':
                case '\'':
                case '\\':
                case 'b':
                case 'f':
                case 'n':
                case 'r':
                case 't':
                    {
                    alt18=1;
                    }
                    break;
                case 'u':
                    {
                    alt18=2;
                    }
                    break;
                case '0':
                case '1':
                case '2':
                case '3':
                case '4':
                case '5':
                case '6':
                case '7':
                    {
                    alt18=3;
                    }
                    break;
                default:
                    NoViableAltException nvae =
                        new NoViableAltException("", 18, 1, input);

                    throw nvae;
                }

            }
            else {
                NoViableAltException nvae =
                    new NoViableAltException("", 18, 0, input);

                throw nvae;
            }
            switch (alt18) {
                case 1 :
                    {
                    match('\\');
                    if ( input.LA(1)=='\"'||input.LA(1)=='\''||input.LA(1)=='\\'||input.LA(1)=='b'||input.LA(1)=='f'||input.LA(1)=='n'||input.LA(1)=='r'||input.LA(1)=='t' ) {
                        input.consume();

                    }
                    else {
                        MismatchedSetException mse = new MismatchedSetException(null,input);
                        recover(mse);
                        throw mse;}

                    }
                    break;
                case 2 :
                    {
                    mUNICODE_ESC();

                    }
                    break;
                case 3 :
                    {
                    mOCTAL_ESC();

                    }
                    break;

            }
        }
        finally {
        }
    }

    public final void mOCTAL_ESC() throws RecognitionException {
        try {
            int alt19=3;
            int LA19_0 = input.LA(1);

            if ( (LA19_0=='\\') ) {
                int LA19_1 = input.LA(2);

                if ( ((LA19_1>='0' && LA19_1<='3')) ) {
                    int LA19_2 = input.LA(3);

                    if ( ((LA19_2>='0' && LA19_2<='7')) ) {
                        int LA19_4 = input.LA(4);

                        if ( ((LA19_4>='0' && LA19_4<='7')) ) {
                            alt19=1;
                        }
                        else {
                            alt19=2;}
                    }
                    else {
                        alt19=3;}
                }
                else if ( ((LA19_1>='4' && LA19_1<='7')) ) {
                    int LA19_3 = input.LA(3);

                    if ( ((LA19_3>='0' && LA19_3<='7')) ) {
                        alt19=2;
                    }
                    else {
                        alt19=3;}
                }
                else {
                    NoViableAltException nvae =
                        new NoViableAltException("", 19, 1, input);

                    throw nvae;
                }
            }
            else {
                NoViableAltException nvae =
                    new NoViableAltException("", 19, 0, input);

                throw nvae;
            }
            switch (alt19) {
                case 1 :
                    {
                    match('\\');
                    {
                    matchRange('0','3');

                    }

                    {
                    matchRange('0','7');

                    }

                    {
                    matchRange('0','7');

                    }

                    }
                    break;
                case 2 :
                    {
                    match('\\');
                    {
                    matchRange('0','7');

                    }

                    {
                    matchRange('0','7');

                    }

                    }
                    break;
                case 3 :
                    {
                    match('\\');
                    {
                    matchRange('0','7');

                    }

                    }
                    break;

            }
        }
        finally {
        }
    }

    public final void mUNICODE_ESC() throws RecognitionException {
        try {
            {
            match('\\');
            match('u');
            mHEX_DIGIT();
            mHEX_DIGIT();
            mHEX_DIGIT();
            mHEX_DIGIT();

            }

        }
        finally {
        }
    }

    public void mTokens() throws RecognitionException {
        int alt20=43;
        alt20 = dfa20.predict(input);
        switch (alt20) {
            case 1 :
                {
                mT__58();

                }
                break;
            case 2 :
                {
                mABS();

                }
                break;
            case 3 :
                {
                mCOUNT();

                }
                break;
            case 4 :
                {
                mDISTANCE();

                }
                break;
            case 5 :
                {
                mGEOPOINT();

                }
                break;
            case 6 :
                {
                mLOG();

                }
                break;
            case 7 :
                {
                mMAX();

                }
                break;
            case 8 :
                {
                mMIN();

                }
                break;
            case 9 :
                {
                mPOW();

                }
                break;
            case 10 :
                {
                mAND();

                }
                break;
            case 11 :
                {
                mOR();

                }
                break;
            case 12 :
                {
                mXOR();

                }
                break;
            case 13 :
                {
                mNOT();

                }
                break;
            case 14 :
                {
                mSNIPPET();

                }
                break;
            case 15 :
                {
                mSWITCH();

                }
                break;
            case 16 :
                {
                mTEXT();

                }
                break;
            case 17 :
                {
                mHTML();

                }
                break;
            case 18 :
                {
                mATOM();

                }
                break;
            case 19 :
                {
                mDATE();

                }
                break;
            case 20 :
                {
                mNUMBER();

                }
                break;
            case 21 :
                {
                mGEO();

                }
                break;
            case 22 :
                {
                mINT();

                }
                break;
            case 23 :
                {
                mPHRASE();

                }
                break;
            case 24 :
                {
                mFLOAT();

                }
                break;
            case 25 :
                {
                mNAME();

                }
                break;
            case 26 :
                {
                mLPAREN();

                }
                break;
            case 27 :
                {
                mRPAREN();

                }
                break;
            case 28 :
                {
                mLSQUARE();

                }
                break;
            case 29 :
                {
                mRSQUARE();

                }
                break;
            case 30 :
                {
                mPLUS();

                }
                break;
            case 31 :
                {
                mMINUS();

                }
                break;
            case 32 :
                {
                mTIMES();

                }
                break;
            case 33 :
                {
                mDIV();

                }
                break;
            case 34 :
                {
                mLT();

                }
                break;
            case 35 :
                {
                mLE();

                }
                break;
            case 36 :
                {
                mGT();

                }
                break;
            case 37 :
                {
                mGE();

                }
                break;
            case 38 :
                {
                mEQ();

                }
                break;
            case 39 :
                {
                mNE();

                }
                break;
            case 40 :
                {
                mCOND();

                }
                break;
            case 41 :
                {
                mQUOTE();

                }
                break;
            case 42 :
                {
                mCOMMA();

                }
                break;
            case 43 :
                {
                mWS();

                }
                break;

        }

    }

    protected DFA13 dfa13 = new DFA13(this);
    protected DFA20 dfa20 = new DFA20(this);
    static final String DFA13_eotS =
        "\6\uffff";
    static final String DFA13_eofS =
        "\6\uffff";
    static final String DFA13_minS =
        "\1\55\2\56\3\uffff";
    static final String DFA13_maxS =
        "\2\71\1\145\3\uffff";
    static final String DFA13_acceptS =
        "\3\uffff\1\2\1\1\1\3";
    static final String DFA13_specialS =
        "\6\uffff}>";
    static final String[] DFA13_transitionS = {
            "\1\1\1\3\1\uffff\12\2",
            "\1\3\1\uffff\12\2",
            "\1\4\1\uffff\12\2\13\uffff\1\5\37\uffff\1\5",
            "",
            "",
            ""
    };

    static final short[] DFA13_eot = DFA.unpackEncodedString(DFA13_eotS);
    static final short[] DFA13_eof = DFA.unpackEncodedString(DFA13_eofS);
    static final char[] DFA13_min = DFA.unpackEncodedStringToUnsignedChars(DFA13_minS);
    static final char[] DFA13_max = DFA.unpackEncodedStringToUnsignedChars(DFA13_maxS);
    static final short[] DFA13_accept = DFA.unpackEncodedString(DFA13_acceptS);
    static final short[] DFA13_special = DFA.unpackEncodedString(DFA13_specialS);
    static final short[][] DFA13_transition;

    static {
        int numStates = DFA13_transitionS.length;
        DFA13_transition = new short[numStates][];
        for (int i=0; i<numStates; i++) {
            DFA13_transition[i] = DFA.unpackEncodedString(DFA13_transitionS[i]);
        }
    }

    class DFA13 extends DFA {

        public DFA13(BaseRecognizer recognizer) {
            this.recognizer = recognizer;
            this.decisionNumber = 13;
            this.eot = DFA13_eot;
            this.eof = DFA13_eof;
            this.min = DFA13_min;
            this.max = DFA13_max;
            this.accept = DFA13_accept;
            this.special = DFA13_special;
            this.transition = DFA13_transition;
        }
        public String getDescription() {
            return "260:1: FLOAT : ( ( '-' )? ( DIGIT )+ '.' ( DIGIT )* ( EXPONENT )? | ( '-' )? '.' ( DIGIT )+ ( EXPONENT )? | ( '-' )? ( DIGIT )+ EXPONENT );";
        }
    }
    static final String DFA20_eotS =
        "\1\uffff\1\43\17\24\1\70\1\71\1\72\10\uffff\1\75\1\77\7\uffff\13"+
        "\24\1\113\7\24\10\uffff\1\123\4\24\1\131\1\132\1\133\1\134\1\135"+
        "\1\136\1\uffff\1\137\1\140\5\24\1\uffff\1\146\2\24\1\151\1\24\10"+
        "\uffff\2\24\1\155\1\156\1\24\1\uffff\1\160\1\24\1\uffff\3\24\2\uffff"+
        "\1\24\1\uffff\3\24\1\171\1\172\2\24\1\175\2\uffff\1\176\1\177\3"+
        "\uffff";
    static final String DFA20_eofS =
        "\u0080\uffff";
    static final String DFA20_minS =
        "\1\11\1\60\1\142\1\157\1\141\1\145\1\157\1\141\1\157\1\116\1\122"+
        "\2\117\1\156\1\145\1\164\1\165\2\56\1\0\10\uffff\2\75\7\uffff\1"+
        "\163\1\157\1\165\1\163\1\164\1\157\1\147\1\170\1\156\1\167\1\104"+
        "\1\44\1\122\1\124\2\151\1\170\2\155\10\uffff\1\44\1\155\1\156\1"+
        "\164\1\145\6\44\1\uffff\2\44\1\160\2\164\1\154\1\142\1\uffff\1\44"+
        "\1\164\1\141\1\44\1\157\10\uffff\1\160\1\143\2\44\1\145\1\uffff"+
        "\1\44\1\156\1\uffff\1\151\1\145\1\150\2\uffff\1\162\1\uffff\1\143"+
        "\1\156\1\164\2\44\1\145\1\164\1\44\2\uffff\2\44\3\uffff";
    static final String DFA20_maxS =
        "\1\172\1\71\1\164\1\157\1\151\1\145\1\157\1\151\1\157\1\116\1\122"+
        "\2\117\1\167\1\145\1\164\1\165\1\71\1\145\1\uffff\10\uffff\2\75"+
        "\7\uffff\1\163\1\157\1\165\1\163\1\164\1\157\1\147\1\170\1\156\1"+
        "\167\1\104\1\172\1\122\1\124\2\151\1\170\2\155\10\uffff\1\172\1"+
        "\155\1\156\1\164\1\145\6\172\1\uffff\2\172\1\160\2\164\1\154\1\142"+
        "\1\uffff\1\172\1\164\1\141\1\172\1\157\10\uffff\1\160\1\143\2\172"+
        "\1\145\1\uffff\1\172\1\156\1\uffff\1\151\1\145\1\150\2\uffff\1\162"+
        "\1\uffff\1\143\1\156\1\164\2\172\1\145\1\164\1\172\2\uffff\2\172"+
        "\3\uffff";
    static final String DFA20_acceptS =
        "\24\uffff\1\31\1\32\1\33\1\34\1\35\1\36\1\40\1\41\2\uffff\1\46\1"+
        "\47\1\50\1\52\1\53\1\1\1\30\23\uffff\1\37\1\26\1\51\1\27\1\43\1"+
        "\42\1\45\1\44\13\uffff\1\13\7\uffff\1\2\5\uffff\1\25\1\6\1\7\1\10"+
        "\1\11\1\12\1\14\1\15\5\uffff\1\22\2\uffff\1\23\3\uffff\1\20\1\21"+
        "\1\uffff\1\3\10\uffff\1\17\1\24\2\uffff\1\16\1\4\1\5";
    static final String DFA20_specialS =
        "\23\uffff\1\0\154\uffff}>";
    static final String[] DFA20_transitionS = {
            "\2\42\2\uffff\1\42\22\uffff\1\42\1\37\1\23\1\uffff\1\24\3\uffff"+
            "\1\25\1\26\1\32\1\31\1\41\1\21\1\1\1\33\12\22\2\uffff\1\34\1"+
            "\36\1\35\1\40\1\uffff\1\11\14\24\1\14\1\12\10\24\1\13\2\24\1"+
            "\27\1\uffff\1\30\1\uffff\1\24\1\uffff\1\2\1\24\1\3\1\4\2\24"+
            "\1\5\1\17\3\24\1\6\1\7\1\20\1\24\1\10\2\24\1\15\1\16\6\24",
            "\12\44",
            "\1\45\21\uffff\1\46",
            "\1\47",
            "\1\51\7\uffff\1\50",
            "\1\52",
            "\1\53",
            "\1\54\7\uffff\1\55",
            "\1\56",
            "\1\57",
            "\1\60",
            "\1\61",
            "\1\62",
            "\1\63\10\uffff\1\64",
            "\1\65",
            "\1\66",
            "\1\67",
            "\1\44\1\uffff\12\22",
            "\1\44\1\uffff\12\22\13\uffff\1\44\37\uffff\1\44",
            "\0\73",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "\1\74",
            "\1\76",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "\1\100",
            "\1\101",
            "\1\102",
            "\1\103",
            "\1\104",
            "\1\105",
            "\1\106",
            "\1\107",
            "\1\110",
            "\1\111",
            "\1\112",
            "\1\24\13\uffff\12\24\7\uffff\32\24\4\uffff\1\24\1\uffff\32"+
            "\24",
            "\1\114",
            "\1\115",
            "\1\116",
            "\1\117",
            "\1\120",
            "\1\121",
            "\1\122",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "\1\24\13\uffff\12\24\7\uffff\32\24\4\uffff\1\24\1\uffff\32"+
            "\24",
            "\1\124",
            "\1\125",
            "\1\126",
            "\1\127",
            "\1\24\13\uffff\12\24\7\uffff\32\24\4\uffff\1\24\1\uffff\17"+
            "\24\1\130\12\24",
            "\1\24\13\uffff\12\24\7\uffff\32\24\4\uffff\1\24\1\uffff\32"+
            "\24",
            "\1\24\13\uffff\12\24\7\uffff\32\24\4\uffff\1\24\1\uffff\32"+
            "\24",
            "\1\24\13\uffff\12\24\7\uffff\32\24\4\uffff\1\24\1\uffff\32"+
            "\24",
            "\1\24\13\uffff\12\24\7\uffff\32\24\4\uffff\1\24\1\uffff\32"+
            "\24",
            "\1\24\13\uffff\12\24\7\uffff\32\24\4\uffff\1\24\1\uffff\32"+
            "\24",
            "",
            "\1\24\13\uffff\12\24\7\uffff\32\24\4\uffff\1\24\1\uffff\32"+
            "\24",
            "\1\24\13\uffff\12\24\7\uffff\32\24\4\uffff\1\24\1\uffff\32"+
            "\24",
            "\1\141",
            "\1\142",
            "\1\143",
            "\1\144",
            "\1\145",
            "",
            "\1\24\13\uffff\12\24\7\uffff\32\24\4\uffff\1\24\1\uffff\32"+
            "\24",
            "\1\147",
            "\1\150",
            "\1\24\13\uffff\12\24\7\uffff\32\24\4\uffff\1\24\1\uffff\32"+
            "\24",
            "\1\152",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "\1\153",
            "\1\154",
            "\1\24\13\uffff\12\24\7\uffff\32\24\4\uffff\1\24\1\uffff\32"+
            "\24",
            "\1\24\13\uffff\12\24\7\uffff\32\24\4\uffff\1\24\1\uffff\32"+
            "\24",
            "\1\157",
            "",
            "\1\24\13\uffff\12\24\7\uffff\32\24\4\uffff\1\24\1\uffff\32"+
            "\24",
            "\1\161",
            "",
            "\1\162",
            "\1\163",
            "\1\164",
            "",
            "",
            "\1\165",
            "",
            "\1\166",
            "\1\167",
            "\1\170",
            "\1\24\13\uffff\12\24\7\uffff\32\24\4\uffff\1\24\1\uffff\32"+
            "\24",
            "\1\24\13\uffff\12\24\7\uffff\32\24\4\uffff\1\24\1\uffff\32"+
            "\24",
            "\1\173",
            "\1\174",
            "\1\24\13\uffff\12\24\7\uffff\32\24\4\uffff\1\24\1\uffff\32"+
            "\24",
            "",
            "",
            "\1\24\13\uffff\12\24\7\uffff\32\24\4\uffff\1\24\1\uffff\32"+
            "\24",
            "\1\24\13\uffff\12\24\7\uffff\32\24\4\uffff\1\24\1\uffff\32"+
            "\24",
            "",
            "",
            ""
    };

    static final short[] DFA20_eot = DFA.unpackEncodedString(DFA20_eotS);
    static final short[] DFA20_eof = DFA.unpackEncodedString(DFA20_eofS);
    static final char[] DFA20_min = DFA.unpackEncodedStringToUnsignedChars(DFA20_minS);
    static final char[] DFA20_max = DFA.unpackEncodedStringToUnsignedChars(DFA20_maxS);
    static final short[] DFA20_accept = DFA.unpackEncodedString(DFA20_acceptS);
    static final short[] DFA20_special = DFA.unpackEncodedString(DFA20_specialS);
    static final short[][] DFA20_transition;

    static {
        int numStates = DFA20_transitionS.length;
        DFA20_transition = new short[numStates][];
        for (int i=0; i<numStates; i++) {
            DFA20_transition[i] = DFA.unpackEncodedString(DFA20_transitionS[i]);
        }
    }

    class DFA20 extends DFA {

        public DFA20(BaseRecognizer recognizer) {
            this.recognizer = recognizer;
            this.decisionNumber = 20;
            this.eot = DFA20_eot;
            this.eof = DFA20_eof;
            this.min = DFA20_min;
            this.max = DFA20_max;
            this.accept = DFA20_accept;
            this.special = DFA20_special;
            this.transition = DFA20_transition;
        }
        public String getDescription() {
            return "1:1: Tokens : ( T__58 | ABS | COUNT | DISTANCE | GEOPOINT | LOG | MAX | MIN | POW | AND | OR | XOR | NOT | SNIPPET | SWITCH | TEXT | HTML | ATOM | DATE | NUMBER | GEO | INT | PHRASE | FLOAT | NAME | LPAREN | RPAREN | LSQUARE | RSQUARE | PLUS | MINUS | TIMES | DIV | LT | LE | GT | GE | EQ | NE | COND | QUOTE | COMMA | WS );";
        }
        public int specialStateTransition(int s, IntStream _input) throws NoViableAltException {
            IntStream input = _input;
        	int _s = s;
            switch ( s ) {
                    case 0 :
                        int LA20_19 = input.LA(1);

                        s = -1;
                        if ( ((LA20_19>='\u0000' && LA20_19<='\uFFFF')) ) {s = 59;}

                        else s = 58;

                        if ( s>=0 ) return s;
                        break;
            }
            NoViableAltException nvae =
                new NoViableAltException(getDescription(), 20, _s, input);
            error(nvae);
            throw nvae;
        }
    }

}
