/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.datanucleus;

import com.google.appengine.datanucleus.DatastorePersistenceHandler;
import java.util.ArrayList;
import java.util.List;

public abstract class BatchManager<T> {
    private final ThreadLocal<List<T>> batchStateList = new ThreadLocal();

    boolean batchOperationInProgress() {
        return this.batchStateList.get() != null;
    }

    public void start() {
        if (this.batchOperationInProgress()) {
            throw new IllegalStateException("Batch " + this.getOperation() + " already running.");
        }
        this.batchStateList.set(new ArrayList());
    }

    public void finish(DatastorePersistenceHandler handler) {
        if (!this.batchOperationInProgress()) {
            throw new IllegalStateException("Batch " + this.getOperation() + " not running.");
        }
        List<T> processMe = this.batchStateList.get();
        this.batchStateList.remove();
        if (!processMe.isEmpty()) {
            this.processBatchState(handler, processMe);
        }
    }

    void add(T batchState) {
        this.batchStateList.get().add(batchState);
    }

    abstract String getOperation();

    abstract void processBatchState(DatastorePersistenceHandler var1, List<T> var2);
}

