/*
 * Decompiled with CFR 0.152.
 */
package org.apache.taglibs.standard.extra.commons.collections.map;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Map;
import org.apache.taglibs.standard.extra.commons.collections.BoundedMap;
import org.apache.taglibs.standard.extra.commons.collections.map.AbstractHashedMap;
import org.apache.taglibs.standard.extra.commons.collections.map.AbstractLinkedMap;

public class LRUMap
extends AbstractLinkedMap
implements BoundedMap,
Serializable,
Cloneable {
    static final long serialVersionUID = -612114643488955218L;
    protected static final int DEFAULT_MAX_SIZE = 100;
    private transient int maxSize;
    private boolean scanUntilRemovable;

    public LRUMap() {
        this(100, 0.75f, false);
    }

    public LRUMap(int n) {
        this(n, 0.75f);
    }

    public LRUMap(int n, boolean bl) {
        this(n, 0.75f, bl);
    }

    public LRUMap(int n, float f) {
        this(n, f, false);
    }

    public LRUMap(int n, float f, boolean bl) {
        super(n < 1 ? 16 : n, f);
        if (n < 1) {
            throw new IllegalArgumentException("LRUMap max size must be greater than 0");
        }
        this.maxSize = n;
        this.scanUntilRemovable = bl;
    }

    public LRUMap(Map map) {
        this(map, false);
    }

    public LRUMap(Map map, boolean bl) {
        this(map.size(), 0.75f, bl);
        this.putAll(map);
    }

    @Override
    public Object get(Object object) {
        AbstractLinkedMap.LinkEntry linkEntry = (AbstractLinkedMap.LinkEntry)this.getEntry(object);
        if (linkEntry == null) {
            return null;
        }
        this.moveToMRU(linkEntry);
        return linkEntry.getValue();
    }

    protected void moveToMRU(AbstractLinkedMap.LinkEntry linkEntry) {
        if (linkEntry.after != this.header) {
            ++this.modCount;
            linkEntry.before.after = linkEntry.after;
            linkEntry.after.before = linkEntry.before;
            linkEntry.after = this.header;
            linkEntry.before = this.header.before;
            this.header.before.after = linkEntry;
            this.header.before = linkEntry;
        }
    }

    @Override
    protected void updateEntry(AbstractHashedMap.HashEntry hashEntry, Object object) {
        this.moveToMRU((AbstractLinkedMap.LinkEntry)hashEntry);
        hashEntry.setValue(object);
    }

    @Override
    protected void addMapping(int n, int n2, Object object, Object object2) {
        if (this.isFull()) {
            AbstractLinkedMap.LinkEntry linkEntry = this.header.after;
            boolean bl = false;
            if (this.scanUntilRemovable) {
                while (linkEntry != this.header) {
                    if (this.removeLRU(linkEntry)) {
                        bl = true;
                        break;
                    }
                    linkEntry = linkEntry.after;
                }
            } else {
                bl = this.removeLRU(linkEntry);
            }
            if (bl) {
                this.reuseMapping(linkEntry, n, n2, object, object2);
            } else {
                super.addMapping(n, n2, object, object2);
            }
        } else {
            super.addMapping(n, n2, object, object2);
        }
    }

    protected void reuseMapping(AbstractLinkedMap.LinkEntry linkEntry, int n, int n2, Object object, Object object2) {
        int n3 = this.hashIndex(linkEntry.hashCode, this.data.length);
        AbstractHashedMap.HashEntry hashEntry = this.data[n3];
        AbstractHashedMap.HashEntry hashEntry2 = null;
        while (hashEntry != linkEntry) {
            hashEntry2 = hashEntry;
            hashEntry = hashEntry.next;
        }
        ++this.modCount;
        this.removeEntry(linkEntry, n3, hashEntry2);
        this.reuseEntry(linkEntry, n, n2, object, object2);
        this.addEntry(linkEntry, n);
    }

    protected boolean removeLRU(AbstractLinkedMap.LinkEntry linkEntry) {
        return true;
    }

    @Override
    public boolean isFull() {
        return this.size >= this.maxSize;
    }

    @Override
    public int maxSize() {
        return this.maxSize;
    }

    public boolean isScanUntilRemovable() {
        return this.scanUntilRemovable;
    }

    @Override
    public Object clone() {
        return super.clone();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        this.doWriteObject(objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.doReadObject(objectInputStream);
    }

    @Override
    protected void doWriteObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeInt(this.maxSize);
        super.doWriteObject(objectOutputStream);
    }

    @Override
    protected void doReadObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.maxSize = objectInputStream.readInt();
        super.doReadObject(objectInputStream);
    }
}

