/*
 * Decompiled with CFR 0.152.
 */
package org.apache.taglibs.standard.lang.jstl;

import org.apache.taglibs.standard.lang.jstl.BinaryOperator;
import org.apache.taglibs.standard.lang.jstl.Coercions;
import org.apache.taglibs.standard.lang.jstl.ELException;
import org.apache.taglibs.standard.lang.jstl.Logger;
import org.apache.taglibs.standard.lang.jstl.PrimitiveObjects;

public class OrOperator
extends BinaryOperator {
    public static final OrOperator SINGLETON = new OrOperator();

    @Override
    public String getOperatorSymbol() {
        return "or";
    }

    @Override
    public Object apply(Object object, Object object2, Object object3, Logger logger) throws ELException {
        boolean bl = Coercions.coerceToBoolean(object, logger);
        boolean bl2 = Coercions.coerceToBoolean(object2, logger);
        return PrimitiveObjects.getBoolean(bl || bl2);
    }

    @Override
    public boolean shouldEvaluate(Object object) {
        return object instanceof Boolean && (Boolean)object == false;
    }

    @Override
    public boolean shouldCoerceToBoolean() {
        return true;
    }
}

